"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const __1 = require("..");
const is_config_schema_1 = require("./is_config_schema");
describe('isConfigSchema', () => {
    it('returns true for every sub classes of `Type`', () => {
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.any())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.arrayOf(__1.schema.string()))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.boolean())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.buffer())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.byteSize())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.duration())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.literal(''))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.mapOf(__1.schema.string(), __1.schema.number()))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.nullable(__1.schema.string()))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.number())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.object({}))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.oneOf([__1.schema.string()]))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.recordOf(__1.schema.string(), __1.schema.object({})))).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.string())).toBe(true);
        expect((0, is_config_schema_1.isConfigSchema)(__1.schema.stream())).toBe(true);
    });
    it('returns false for every javascript data type', () => {
        expect((0, is_config_schema_1.isConfigSchema)('foo')).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)(42)).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)(new Date())).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)(null)).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)(undefined)).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)([1, 2, 3])).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)({ foo: 'bar' })).toBe(false);
        expect((0, is_config_schema_1.isConfigSchema)(function () { })).toBe(false);
    });
    it('returns true as long as `__isOsdConfigSchemaType` is true', () => {
        expect((0, is_config_schema_1.isConfigSchema)({ __isOsdConfigSchemaType: true })).toBe(true);
    });
});
