"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const read_argv_1 = require("./read_argv");
describe('getArgValues', () => {
    it('retrieve the arg value from the provided argv arguments', () => {
        const argValues = (0, read_argv_1.getArgValues)(['--config', 'my-config', '--foo', '-b', 'bar', '--config', 'other-config', '--baz'], '--config');
        expect(argValues).toEqual(['my-config', 'other-config']);
    });
    it('accept aliases', () => {
        const argValues = (0, read_argv_1.getArgValues)(['--config', 'my-config', '--foo', '-b', 'bar', '-c', 'other-config', '--baz'], ['--config', '-c']);
        expect(argValues).toEqual(['my-config', 'other-config']);
    });
    it('returns an empty array when the arg is not found', () => {
        const argValues = (0, read_argv_1.getArgValues)(['--config', 'my-config', '--foo', '-b', 'bar', '-c', 'other-config', '--baz'], '--unicorn');
        expect(argValues).toEqual([]);
    });
    it('ignores the flag when no value is provided', () => {
        const argValues = (0, read_argv_1.getArgValues)(['-c', 'my-config', '--foo', '-b', 'bar', '--config'], ['--config', '-c']);
        expect(argValues).toEqual(['my-config']);
    });
});
describe('getArgValue', () => {
    it('retrieve the first arg value from the provided argv arguments', () => {
        const argValues = (0, read_argv_1.getArgValue)(['--config', 'my-config', '--foo', '-b', 'bar', '--config', 'other-config', '--baz'], '--config');
        expect(argValues).toEqual('my-config');
    });
    it('accept aliases', () => {
        const argValues = (0, read_argv_1.getArgValue)(['-c', 'my-config', '--foo', '-b', 'bar', '--config', 'other-config', '--baz'], ['--config', '-c']);
        expect(argValues).toEqual('my-config');
    });
    it('returns undefined the arg is not found', () => {
        const argValues = (0, read_argv_1.getArgValue)(['--config', 'my-config', '--foo', '-b', 'bar', '-c', 'other-config', '--baz'], '--unicorn');
        expect(argValues).toBeUndefined();
    });
});
