"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const path_1 = require("path");
const utils_1 = require("@osd/utils");
const get_config_file_paths_1 = require("./get_config_file_paths");
describe('getConfigurationFilePaths', () => {
    const cwd = process.cwd();
    it('retrieve the config file paths from the command line arguments', () => {
        const argv = ['--config', './relative-path', '-c', '/absolute-path'];
        expect((0, get_config_file_paths_1.getConfigurationFilePaths)(argv)).toEqual([
            (0, path_1.resolve)(cwd, (0, path_1.join)('.', 'relative-path')),
            (0, path_1.resolve)('/absolute-path'),
        ]);
    });
    it('fallbacks to `getConfigPath` value', () => {
        expect((0, get_config_file_paths_1.getConfigurationFilePaths)([])).toEqual([(0, utils_1.getConfigPath)()]);
    });
});
