"use strict";
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */
Object.defineProperty(exports, "__esModule", { value: true });
/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
const config_loader_test_mocks_1 = require("./config_loader.test.mocks");
const config_loader_1 = require("./config_loader");
describe('loadConfiguration', () => {
    const argv = ['some', 'arbitrary', 'args'];
    const rootDir = '/root/dir';
    const isDistributable = false;
    afterEach(() => {
        (0, config_loader_test_mocks_1.resetAllMocks)();
    });
    it('calls `getConfigurationFilePaths` with the correct arguments', () => {
        (0, config_loader_1.loadConfiguration)(argv, rootDir, isDistributable);
        expect(config_loader_test_mocks_1.getConfigurationFilePathsMock).toHaveBeenCalledTimes(1);
        expect(config_loader_test_mocks_1.getConfigurationFilePathsMock).toHaveBeenCalledWith(argv);
    });
    it('calls `getConfigFromFiles` with the correct arguments', () => {
        const configPaths = ['/path/to/config', '/path/to/other/config'];
        config_loader_test_mocks_1.getConfigurationFilePathsMock.mockReturnValue(configPaths);
        (0, config_loader_1.loadConfiguration)(argv, rootDir, isDistributable);
        expect(config_loader_test_mocks_1.getConfigFromFilesMock).toHaveBeenCalledTimes(1);
        expect(config_loader_test_mocks_1.getConfigFromFilesMock).toHaveBeenCalledWith(configPaths);
    });
    it('calls `applyConfigOverrides` with the correct arguments', () => {
        const config = { server: { uuid: 'uuid' } };
        config_loader_test_mocks_1.getConfigFromFilesMock.mockReturnValue(config);
        (0, config_loader_1.loadConfiguration)(argv, rootDir, isDistributable);
        expect(config_loader_test_mocks_1.applyConfigOverridesMock).toHaveBeenCalledTimes(1);
        expect(config_loader_test_mocks_1.applyConfigOverridesMock).toHaveBeenCalledWith(config, argv);
    });
    it('creates and return an `ApmConfiguration` instance', () => {
        const apmInstance = { apmInstance: true };
        config_loader_test_mocks_1.ApmConfigurationMock.mockImplementation(() => apmInstance);
        const config = { server: { uuid: 'uuid' } };
        config_loader_test_mocks_1.getConfigFromFilesMock.mockReturnValue(config);
        const instance = (0, config_loader_1.loadConfiguration)(argv, rootDir, isDistributable);
        expect(config_loader_test_mocks_1.ApmConfigurationMock).toHaveBeenCalledTimes(1);
        expect(config_loader_test_mocks_1.ApmConfigurationMock).toHaveBeenCalledWith(rootDir, config, isDistributable);
        expect(instance).toBe(apmInstance);
    });
});
