"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderTestElement = exports.act = void 0;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = _interopRequireWildcard(require("react"));
var _react_dom = require("../services/react_dom");
function _interopRequireWildcard(e, t) { if ("function" == typeof WeakMap) var r = new WeakMap(), n = new WeakMap(); return (_interopRequireWildcard = function _interopRequireWildcard(e, t) { if (!t && e && e.__esModule) return e; var o, i, f = { __proto__: null, default: e }; if (null === e || "object" != _typeof(e) && "function" != typeof e) return f; if (o = t ? n : r) { if (o.has(e)) return o.get(e); o.set(e, f); } for (var _t in e) { "default" !== _t && {}.hasOwnProperty.call(e, _t) && ((i = (o = Object.defineProperty) && Object.getOwnPropertyDescriptor(e, _t)) && (i.get || i.set) ? o(f, _t, i) : f[_t] = e[_t]); } return f; })(e, t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * This is a compatibility layer for React's act() function.
 * In React 18+, act is exported directly from 'react'.
 * In React <18, we use it from 'react-dom/test-utils'.
 */
var _version$split$map = _react.version.split('.').map(Number),
  _version$split$map2 = (0, _slicedToArray2.default)(_version$split$map, 1),
  major = _version$split$map2[0]; // Dynamic import to avoid loading both modules
var act =
// eslint-disable-next-line @typescript-eslint/no-var-requires
major >= 18 ? _react.default.act : require('react-dom/test-utils').act;

/**
 * Renders a React element into a detached DOM node
 * Works with both React 16's ReactDOM.render and React 18's createRoot
 */
exports.act = act;
var renderTestElement = function renderTestElement(element) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var container = document.createElement('div');
  var _options$attachToDocu = options.attachToDocument,
    attachToDocument = _options$attachToDocu === void 0 ? true : _options$attachToDocu;
  if (attachToDocument) {
    document.body.appendChild(container);
  }
  var root = (0, _react_dom.render)(element, container);
  return {
    container: container,
    cleanup: function cleanup() {
      root.unmount();
      if (attachToDocument) {
        document.body.removeChild(container);
      }
    }
  };
};
exports.renderTestElement = renderTestElement;