# Installation
> `npm install --save @types/react-input-autosize`

# Summary
This package contains type definitions for react-input-autosize (https://github.com/JedWatson/react-input-autosize#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-input-autosize.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-input-autosize/index.d.ts)
````ts
import * as React from "react";

export interface AutosizeInputProps
    extends React.InputHTMLAttributes<HTMLInputElement>, React.ClassAttributes<HTMLInputElement>
{
    inputClassName?: string | undefined;
    inputRef?: ((instance: HTMLInputElement | null) => void) | undefined;
    inputStyle?: React.CSSProperties | undefined;
    minWidth?: string | number | undefined;
    onAutosize?: ((inputWidth: string | number) => void) | undefined;
    placeholderIsMinWidth?: boolean | undefined;
    extraWidth?: string | number | undefined;
    injectStyles?: boolean | undefined;
}

declare class AutosizeInput extends React.Component<AutosizeInputProps> {
    copyInputStyles(): void;
    getInput(): HTMLInputElement;
}

export default AutosizeInput;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [Jason Unger](https://github.com/jsonunger), and [Frank Li](https://github.com/franklixuefei).
