/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.otellogs;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpServiceWithRoutes;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.encoding.DecodingService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.GrpcServiceBuilder;
import com.linecorp.armeria.server.healthcheck.HealthCheckService;
import com.linecorp.armeria.server.throttling.ThrottlingRejectHandler;
import com.linecorp.armeria.server.throttling.ThrottlingService;
import com.linecorp.armeria.server.throttling.ThrottlingStrategy;
import io.grpc.BindableService;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.protobuf.services.ProtoReflectionService;
import io.opentelemetry.proto.collector.logs.v1.LogsServiceGrpc;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.Function;
import org.opensearch.dataprepper.GrpcRequestExceptionHandler;
import org.opensearch.dataprepper.armeria.authentication.ArmeriaHttpAuthenticationProvider;
import org.opensearch.dataprepper.armeria.authentication.GrpcAuthenticationProvider;
import org.opensearch.dataprepper.http.LogThrottlingRejectHandler;
import org.opensearch.dataprepper.http.LogThrottlingStrategy;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.codec.ByteDecoder;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.certificate.CertificateProvider;
import org.opensearch.dataprepper.plugins.certificate.model.Certificate;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.otel.codec.OTelLogsDecoder;
import org.opensearch.dataprepper.plugins.otel.codec.OTelOutputFormat;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoOpensearchCodec;
import org.opensearch.dataprepper.plugins.otel.codec.OTelProtoStandardCodec;
import org.opensearch.dataprepper.plugins.server.CreateServer;
import org.opensearch.dataprepper.plugins.server.HealthGrpcService;
import org.opensearch.dataprepper.plugins.server.RetryInfoConfig;
import org.opensearch.dataprepper.plugins.source.otellogs.OTelLogsGrpcService;
import org.opensearch.dataprepper.plugins.source.otellogs.OTelLogsSourceConfig;
import org.opensearch.dataprepper.plugins.source.otellogs.certificate.CertificateProviderFactory;
import org.opensearch.dataprepper.plugins.source.otellogs.http.ArmeriaHttpService;
import org.opensearch.dataprepper.plugins.source.otellogs.http.HttpExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="otel_logs_source", pluginType=Source.class, pluginConfigurationType=OTelLogsSourceConfig.class)
public class OTelLogsSource
implements Source<Record<Object>> {
    private static final Logger LOG = LoggerFactory.getLogger(OTelLogsSource.class);
    static final String SERVER_CONNECTIONS = "serverConnections";
    static final String HEALTH_CHECK_PATH = "/health";
    static final int MAX_PENDING_REQUESTS = 1024;
    private final OTelLogsSourceConfig oTelLogsSourceConfig;
    private final String pipelineName;
    private final PluginMetrics pluginMetrics;
    private final CertificateProviderFactory certificateProviderFactory;
    private final ByteDecoder byteDecoder;
    private final PluginFactory pluginFactory;
    private Server server;

    @DataPrepperPluginConstructor
    public OTelLogsSource(OTelLogsSourceConfig oTelLogsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, PipelineDescription pipelineDescription) {
        this(oTelLogsSourceConfig, pluginMetrics, pluginFactory, new CertificateProviderFactory(oTelLogsSourceConfig), pipelineDescription);
    }

    OTelLogsSource(OTelLogsSourceConfig oTelLogsSourceConfig, PluginMetrics pluginMetrics, PluginFactory pluginFactory, CertificateProviderFactory certificateProviderFactory, PipelineDescription pipelineDescription) {
        oTelLogsSourceConfig.validateAndInitializeCertAndKeyFileInS3();
        this.oTelLogsSourceConfig = oTelLogsSourceConfig;
        this.pluginMetrics = pluginMetrics;
        this.certificateProviderFactory = certificateProviderFactory;
        this.pipelineName = pipelineDescription.getPipelineName();
        this.pluginFactory = pluginFactory;
        this.byteDecoder = new OTelLogsDecoder(oTelLogsSourceConfig.getOutputFormat());
    }

    public ByteDecoder getDecoder() {
        return this.byteDecoder;
    }

    public void start(Buffer<Record<Object>> buffer) {
        if (buffer == null) {
            throw new IllegalStateException("Buffer provided is null");
        }
        SessionProtocol protocol = this.oTelLogsSourceConfig.isSsl() ? SessionProtocol.HTTPS : SessionProtocol.HTTP;
        ServerBuilder serverBuilder = Server.builder().port(this.oTelLogsSourceConfig.getPort(), new SessionProtocol[]{protocol});
        if (this.server == null) {
            this.server = this.createServer(serverBuilder, buffer);
            this.pluginMetrics.gauge(SERVER_CONNECTIONS, (Object)this.server, Server::numConnections);
        }
        try {
            this.server.start().get();
        }
        catch (ExecutionException ex) {
            if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                throw (RuntimeException)ex.getCause();
            }
            throw new RuntimeException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
        LOG.info("Started otel_logs_source...");
    }

    private Server createServer(ServerBuilder serverBuilder, Buffer<Record<Object>> buffer) {
        serverBuilder.disableServerHeader();
        if (this.oTelLogsSourceConfig.isSsl()) {
            LOG.info("Creating http source with SSL/TLS enabled.");
            CertificateProvider certificateProvider = this.certificateProviderFactory.getCertificateProvider();
            Certificate certificate = certificateProvider.getCertificate();
            serverBuilder.https(this.oTelLogsSourceConfig.getPort()).tls((InputStream)new ByteArrayInputStream(certificate.getCertificate().getBytes(StandardCharsets.UTF_8)), (InputStream)new ByteArrayInputStream(certificate.getPrivateKey().getBytes(StandardCharsets.UTF_8)));
        } else {
            LOG.warn("Creating otlp logs source without SSL/TLS. This is not secure.");
            LOG.warn("In order to set up TLS for the otlp logs source, go here: https://docs.opensearch.org/latest/data-prepper/pipelines/configuration/sources/otel-logs-source/#ssl");
            serverBuilder.http(this.oTelLogsSourceConfig.getPort());
        }
        if (this.oTelLogsSourceConfig.getAuthentication() != null) {
            this.createHttpAuthentication().flatMap(ArmeriaHttpAuthenticationProvider::getAuthenticationDecorator).ifPresent(arg_0 -> ((ServerBuilder)serverBuilder).decorator(arg_0));
        }
        serverBuilder.maxNumConnections(this.oTelLogsSourceConfig.getMaxConnectionCount());
        serverBuilder.requestTimeout(Duration.ofMillis(this.oTelLogsSourceConfig.getRequestTimeoutInMillis()));
        if (this.oTelLogsSourceConfig.getMaxRequestLength() != null) {
            serverBuilder.maxRequestLength(this.oTelLogsSourceConfig.getMaxRequestLength().getBytes());
        }
        int threadCount = this.oTelLogsSourceConfig.getThreadCount();
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(threadCount);
        serverBuilder.blockingTaskExecutor((ScheduledExecutorService)executor, true);
        if (this.oTelLogsSourceConfig.hasHealthCheck()) {
            LOG.info("HTTP source health check is enabled");
            serverBuilder.service(HEALTH_CHECK_PATH, (HttpService)HealthCheckService.builder().longPolling(0L).build());
        }
        this.configureGrpcService(serverBuilder, buffer);
        this.configureHttpService(serverBuilder, buffer, executor.getQueue());
        return serverBuilder.build();
    }

    private void configureHttpService(ServerBuilder serverBuilder, Buffer<Record<Object>> buffer, BlockingQueue<Runnable> blockingQueue) {
        String path = this.oTelLogsSourceConfig.getHttpPath().replace("${pipelineName}", this.pipelineName);
        LOG.info("Configuring HTTP service under {} ", (Object)path);
        ArmeriaHttpService armeriaHttpService = new ArmeriaHttpService(buffer, this.pluginMetrics, 100, this.createOtelProtoDecoder());
        RetryInfoConfig retryInfo = this.oTelLogsSourceConfig.getRetryInfo() != null ? this.oTelLogsSourceConfig.getRetryInfo() : new RetryInfoConfig();
        HttpExceptionHandler httpExceptionHandler = new HttpExceptionHandler(this.pluginMetrics, retryInfo.getMinDelay(), retryInfo.getMaxDelay());
        int maxPendingRequests = 1024;
        LogThrottlingStrategy logThrottlingStrategy = new LogThrottlingStrategy(1024, blockingQueue);
        LogThrottlingRejectHandler logThrottlingRejectHandler = new LogThrottlingRejectHandler(1024, this.pluginMetrics);
        serverBuilder.decorator(path, ThrottlingService.newDecorator((ThrottlingStrategy)logThrottlingStrategy, (ThrottlingRejectHandler)logThrottlingRejectHandler));
        if (CompressionOption.NONE.equals((Object)this.oTelLogsSourceConfig.getCompression())) {
            serverBuilder.annotatedService(path, (Object)armeriaHttpService, new Object[]{httpExceptionHandler});
        } else {
            serverBuilder.annotatedService(path, (Object)armeriaHttpService, DecodingService.newDecorator(), new Object[]{httpExceptionHandler});
        }
    }

    private void configureGrpcService(ServerBuilder serverBuilder, Buffer<Record<Object>> buffer) {
        LOG.info("Configuring gRPC service");
        GrpcServiceBuilder grpcServiceBuilder = GrpcService.builder().useClientTimeoutHeader(false).useBlockingTaskExecutor(true).exceptionHandler(this.createGrpExceptionHandler(this.oTelLogsSourceConfig));
        OTelLogsGrpcService oTelLogsGrpcService = new OTelLogsGrpcService((int)((double)this.oTelLogsSourceConfig.getRequestTimeoutInMillis() * 0.8), this.createOtelProtoDecoder(), buffer, this.pluginMetrics, null);
        GrpcAuthenticationProvider authProvider = this.createGrpcAuthenticationProvider(this.pluginFactory);
        ArrayList<ServerInterceptor> interceptors = new ArrayList<ServerInterceptor>();
        if (authProvider.getAuthenticationInterceptor() != null) {
            interceptors.add(authProvider.getAuthenticationInterceptor());
        }
        if (this.oTelLogsSourceConfig.enableUnframedRequests()) {
            grpcServiceBuilder.enableUnframedRequests(true);
        }
        CreateServer.GRPCServiceConfig grpcServiceConfig = new CreateServer.GRPCServiceConfig((BindableService)oTelLogsGrpcService);
        if (this.oTelLogsSourceConfig.getPath() != null) {
            String path = this.oTelLogsSourceConfig.getPath().replace("${pipelineName}", this.pipelineName);
            LOG.info("custom gRPC path: {} ", (Object)path);
            grpcServiceBuilder.addService(path, ServerInterceptors.intercept((BindableService)grpcServiceConfig.getService(), interceptors), LogsServiceGrpc.getExportMethod());
        } else {
            grpcServiceBuilder.addService(ServerInterceptors.intercept((BindableService)grpcServiceConfig.getService(), interceptors));
        }
        if (this.oTelLogsSourceConfig.hasHealthCheck()) {
            LOG.info("Health check for gRPC service is enabled");
            grpcServiceBuilder.addService((BindableService)new HealthGrpcService());
        }
        if (this.oTelLogsSourceConfig.hasProtoReflectionService()) {
            LOG.info("Proto reflection service is enabled");
            grpcServiceBuilder.addService(ProtoReflectionService.newInstance());
        }
        if (CompressionOption.NONE.equals((Object)this.oTelLogsSourceConfig.getCompression())) {
            serverBuilder.service((HttpServiceWithRoutes)grpcServiceBuilder.build(), new Function[0]);
        } else {
            serverBuilder.service((HttpServiceWithRoutes)grpcServiceBuilder.build(), new Function[]{DecodingService.newDecorator()});
        }
    }

    private OTelProtoCodec.OTelProtoDecoder createOtelProtoDecoder() {
        return this.oTelLogsSourceConfig.getOutputFormat() == OTelOutputFormat.OPENSEARCH ? new OTelProtoOpensearchCodec.OTelProtoDecoder() : new OTelProtoStandardCodec.OTelProtoDecoder();
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop().get();
            }
            catch (ExecutionException ex) {
                if (ex.getCause() != null && ex.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ex.getCause();
                }
                throw new RuntimeException(ex);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(ex);
            }
        }
        LOG.info("Stopped otel_logs_source.");
    }

    private GrpcAuthenticationProvider createGrpcAuthenticationProvider(PluginFactory pluginFactory) {
        PluginModel authenticationConfiguration = this.oTelLogsSourceConfig.getAuthentication();
        if (authenticationConfiguration == null || authenticationConfiguration.getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel-logs-source without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-logs-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-logs-source#authentication-configurations");
        }
        PluginSetting authenticationPluginSetting = authenticationConfiguration != null ? new PluginSetting(authenticationConfiguration.getPluginName(), authenticationConfiguration.getPluginSettings()) : new PluginSetting("unauthenticated", Collections.emptyMap());
        authenticationPluginSetting.setPipelineName(this.pipelineName);
        return (GrpcAuthenticationProvider)pluginFactory.loadPlugin(GrpcAuthenticationProvider.class, authenticationPluginSetting, new Object[0]);
    }

    private Optional<ArmeriaHttpAuthenticationProvider> createHttpAuthentication() {
        if (this.oTelLogsSourceConfig.getAuthentication() == null || this.oTelLogsSourceConfig.getAuthentication().getPluginName().equals("unauthenticated")) {
            LOG.warn("Creating otel_trace_source http service without authentication. This is not secure.");
            LOG.warn("In order to set up Http Basic authentication for the otel-trace-source, go here: https://github.com/opensearch-project/data-prepper/tree/main/data-prepper-plugins/otel-trace-source#authentication-configurations");
            return Optional.empty();
        }
        return Optional.of(this.createGrpcAuthenticationProvider(this.oTelLogsSourceConfig.getAuthentication()));
    }

    private ArmeriaHttpAuthenticationProvider createGrpcAuthenticationProvider(PluginModel authenticationConfiguration) {
        Map pluginSettings = authenticationConfiguration.getPluginSettings();
        return (ArmeriaHttpAuthenticationProvider)this.pluginFactory.loadPlugin(ArmeriaHttpAuthenticationProvider.class, new PluginSetting(authenticationConfiguration.getPluginName(), pluginSettings), new Object[0]);
    }

    private GrpcExceptionHandlerFunction createGrpExceptionHandler(OTelLogsSourceConfig config) {
        RetryInfoConfig retryInfo = config.getRetryInfo() != null ? config.getRetryInfo() : new RetryInfoConfig();
        return new GrpcRequestExceptionHandler(this.pluginMetrics, retryInfo.getMinDelay(), retryInfo.getMaxDelay());
    }
}

