/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.oteltrace;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GenAiAttributeMappings {
    private static final Logger LOG = LoggerFactory.getLogger(GenAiAttributeMappings.class);
    static final String MAPPINGS_FILE = "genai-attribute-mappings.yaml";
    private static final Map<String, MappingTarget> LOOKUP_TABLE;
    private static final Map<String, String> OPERATION_NAME_VALUES;

    private GenAiAttributeMappings() {
    }

    static Map<String, MappingTarget> getLookupTable() {
        return LOOKUP_TABLE;
    }

    static Map<String, String> getOperationNameValues() {
        return OPERATION_NAME_VALUES;
    }

    private static Map<String, MappingTarget> buildLookupTable(Map<String, Object> yaml) {
        HashMap<String, MappingTarget> table = new HashMap<String, MappingTarget>();
        for (Map.Entry<String, Object> profile : yaml.entrySet()) {
            if (!(profile.getValue() instanceof List)) continue;
            for (Object entry : (List)profile.getValue()) {
                if (!(entry instanceof Map)) continue;
                Map mapping = (Map)entry;
                String from = (String)mapping.get("from");
                String to = (String)mapping.get("to");
                if (from == null || to == null) continue;
                boolean wrapSlice = Boolean.TRUE.equals(mapping.get("wrap_as_array"));
                table.putIfAbsent(from, new MappingTarget(to, wrapSlice));
            }
        }
        return table;
    }

    private static Map<String, String> buildOperationNameValues(Map<String, Object> yaml) {
        Object raw = yaml.get("operation_name_values");
        if (!(raw instanceof Map)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> values = new HashMap<String, String>();
        for (Map.Entry entry : ((Map)raw).entrySet()) {
            values.put(((String)entry.getKey()).toLowerCase(), (String)entry.getValue());
        }
        return values;
    }

    static {
        Map<Object, Object> lookupTable = Collections.emptyMap();
        Map<Object, Object> operationNameValues = Collections.emptyMap();
        try (InputStream is = GenAiAttributeMappings.class.getClassLoader().getResourceAsStream(MAPPINGS_FILE);){
            if (is == null) {
                LOG.error("GenAI attribute mappings file not found: {}", (Object)MAPPINGS_FILE);
            } else {
                ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
                Map yaml = (Map)mapper.readValue(is, Map.class);
                lookupTable = GenAiAttributeMappings.buildLookupTable(yaml);
                operationNameValues = GenAiAttributeMappings.buildOperationNameValues(yaml);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to load GenAI attribute mappings from {}", (Object)MAPPINGS_FILE, (Object)e);
        }
        LOOKUP_TABLE = Collections.unmodifiableMap(lookupTable);
        OPERATION_NAME_VALUES = Collections.unmodifiableMap(operationNameValues);
    }

    static final class MappingTarget {
        private final String key;
        private final boolean wrapAsArray;

        MappingTarget(String key, boolean wrapAsArray) {
            this.key = key;
            this.wrapAsArray = wrapAsArray;
        }

        String getKey() {
            return this.key;
        }

        boolean isWrapAsArray() {
            return this.wrapAsArray;
        }
    }
}

