/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.logstash.parser;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.logstash.LogstashBaseVisitor;
import org.opensearch.dataprepper.logstash.LogstashParser;
import org.opensearch.dataprepper.logstash.exception.LogstashParsingException;
import org.opensearch.dataprepper.logstash.model.LogstashAttribute;
import org.opensearch.dataprepper.logstash.model.LogstashAttributeValue;
import org.opensearch.dataprepper.logstash.model.LogstashConfiguration;
import org.opensearch.dataprepper.logstash.model.LogstashPlugin;
import org.opensearch.dataprepper.logstash.model.LogstashPluginType;
import org.opensearch.dataprepper.logstash.model.LogstashValueType;

public class ModelConvertingLogstashVisitor
extends LogstashBaseVisitor {
    @Override
    public Object visitConfig(LogstashParser.ConfigContext configContext) {
        LinkedHashMap<LogstashPluginType, List<LogstashPlugin>> pluginSections = new LinkedHashMap<LogstashPluginType, List<LogstashPlugin>>();
        configContext.plugin_section().forEach(pluginSection -> {
            String pluginType = pluginSection.plugin_type().getText();
            if (!Arrays.asList("input", "filter", "output").contains(pluginType)) {
                throw new LogstashParsingException("only input, filter and output plugin sections are supported.");
            }
            LogstashPluginType logstashPluginType = LogstashPluginType.getByValue(pluginType);
            List logstashPluginList = (List)this.visitPlugin_section((LogstashParser.Plugin_sectionContext)((Object)pluginSection));
            pluginSections.put(logstashPluginType, logstashPluginList);
        });
        return LogstashConfiguration.builder().pluginSections(pluginSections).build();
    }

    @Override
    public Object visitPlugin_section(LogstashParser.Plugin_sectionContext pluginSectionContext) {
        return pluginSectionContext.branch_or_plugin().stream().map(this::visitBranch_or_plugin).collect(Collectors.toList());
    }

    @Override
    public Object visitBranch_or_plugin(LogstashParser.Branch_or_pluginContext branchOrPluginContext) {
        if (branchOrPluginContext.getChild(0) instanceof LogstashParser.PluginContext) {
            return this.visitPlugin(branchOrPluginContext.plugin());
        }
        throw new LogstashParsingException("conditionals are not supported");
    }

    @Override
    public Object visitPlugin(LogstashParser.PluginContext pluginContext) {
        String pluginName = this.normalizeText(pluginContext.name().getText());
        List<LogstashAttribute> logstashAttributeList = pluginContext.attributes().attribute().stream().map(attribute -> (LogstashAttribute)this.visitAttribute((LogstashParser.AttributeContext)((Object)attribute))).filter(Objects::nonNull).collect(Collectors.toList());
        return LogstashPlugin.builder().pluginName(pluginName).attributes(logstashAttributeList).build();
    }

    @Override
    public Object visitAttribute(LogstashParser.AttributeContext attributeContext) {
        AttributeInformation info = this.getAttributeInformation(attributeContext.value());
        if (info == null) {
            return null;
        }
        LogstashAttributeValue logstashAttributeValue = LogstashAttributeValue.builder().attributeValueType(info.logstashValueType).value(info.value).build();
        return LogstashAttribute.builder().attributeName(this.normalizeText(attributeContext.name().getText())).attributeValue(logstashAttributeValue).build();
    }

    @Override
    public Object visitArray(LogstashParser.ArrayContext arrayContext) {
        return arrayContext.value().stream().map(RuleContext::getText).map(this::normalizeText).collect(Collectors.toList());
    }

    @Override
    public Object visitHash(LogstashParser.HashContext hashContext) {
        return this.visitHashentries(hashContext.hashentries());
    }

    @Override
    public Object visitHashentries(LogstashParser.HashentriesContext hashentriesContext) {
        LinkedHashMap hashEntries = new LinkedHashMap();
        hashentriesContext.hashentry().forEach(hashentryContext -> {
            String key = this.normalizeText(hashentryContext.hashname().getText());
            Object value = this.visitHashentry((LogstashParser.HashentryContext)((Object)hashentryContext));
            hashEntries.put(key, value);
        });
        return hashEntries;
    }

    @Override
    public Object visitHashentry(LogstashParser.HashentryContext hashentryContext) {
        if (hashentryContext.value().getChild(0) instanceof LogstashParser.ArrayContext) {
            return this.visitArray(hashentryContext.value().array());
        }
        AttributeInformation info = this.getAttributeInformation(hashentryContext.value());
        if (info.value == null) {
            info.value = this.normalizeText(hashentryContext.value().getText());
        }
        return info.value;
    }

    private String normalizeText(String unNormalizedLogstashText) {
        return unNormalizedLogstashText.replaceAll("^\"|\"$|^'|'$", "");
    }

    private AttributeInformation getAttributeInformation(LogstashParser.ValueContext value) {
        AttributeInformation info = new AttributeInformation();
        if (value == null) {
            return null;
        }
        if (value.getChild(0) instanceof LogstashParser.ArrayContext) {
            info.logstashValueType = LogstashValueType.ARRAY;
            info.value = this.visitArray(value.array());
        } else if (value.getChild(0) instanceof LogstashParser.HashContext) {
            info.logstashValueType = LogstashValueType.HASH;
            info.value = this.visitHash(value.hash());
        } else {
            if (value.getChild(0) instanceof LogstashParser.PluginContext) {
                throw new LogstashParsingException("plugins are not supported in an attribute");
            }
            if (value.NUMBER() != null && value.getText().equals(value.NUMBER().toString())) {
                info.logstashValueType = LogstashValueType.NUMBER;
                try {
                    info.value = Integer.parseInt(value.getText());
                }
                catch (NumberFormatException e) {
                    try {
                        info.value = Double.parseDouble(value.getText());
                    }
                    catch (NumberFormatException exception) {
                        throw new LogstashParsingException("NUMBER types must be either Integer or Double");
                    }
                }
            } else if (value.BAREWORD() != null && value.getText().equals(value.BAREWORD().toString())) {
                info.logstashValueType = LogstashValueType.BAREWORD;
                info.value = value.getText();
                if (info.value.toString().equals("true") || info.value.toString().equals("false")) {
                    info.value = Boolean.parseBoolean(info.value.toString());
                }
            } else if (value.STRING() != null && value.getText().equals(value.STRING().toString())) {
                info.logstashValueType = LogstashValueType.STRING;
                info.value = this.normalizeText(value.getText());
            }
        }
        return info;
    }

    private class AttributeInformation {
        LogstashValueType logstashValueType = null;
        Object value = null;

        private AttributeInformation() {
        }
    }
}

