/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.kafka.service;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.lang3.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.opensearch.dataprepper.plugins.kafka.configuration.SchemaConfig;
import org.opensearch.dataprepper.plugins.kafka.util.JsonUtils;
import org.opensearch.dataprepper.plugins.kafka.util.RestUtils;
import org.opensearch.dataprepper.plugins.kafka.util.SinkPropertyConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;

public class SchemaService {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaService.class);
    private CachedSchemaRegistryClient schemaRegistryClient;
    private static final int cacheCapacity = 100;
    private static final String REGISTER_API_PATH = "/subjects/%s/versions?normalize=false";
    private static final String COMPATIBILITY_API_PATH = "compatibility/subjects/%s/versions/%s";
    private final String schemaString;
    private final String serdeFormat;
    private final String topic;
    private final SchemaConfig schemaConfig;
    private RestUtils restUtils;
    private final JsonUtils jsonUtils = new JsonUtils();

    private SchemaService(SchemaServiceBuilder builder) {
        this.serdeFormat = builder.serdeFormat;
        this.schemaConfig = builder.schemaConfig;
        this.topic = builder.topic;
        this.restUtils = builder.restUtils;
        this.schemaString = this.getSchemaString();
        this.schemaRegistryClient = builder.cachedSchemaRegistryClient;
    }

    public Schema getSchema(String topic) {
        String valueToParse = this.getValueToParse(topic);
        if (ObjectUtils.isEmpty((Object)valueToParse)) {
            return null;
        }
        return new Schema.Parser().parse(valueToParse);
    }

    public String getValueToParse(String topic) {
        try {
            if (this.schemaRegistryClient != null) {
                return this.schemaRegistryClient.getLatestSchemaMetadata(topic).getSchema();
            }
        }
        catch (RestClientException | IOException e) {
            LOG.warn(e.getMessage());
        }
        return null;
    }

    public void registerSchema(String topic) {
        try {
            String oldSchema = this.getValueToParse(topic);
            if (ObjectUtils.isEmpty((Object)oldSchema)) {
                this.registerSchema(topic, this.schemaString);
            } else if (this.isSchemaDifferent(oldSchema, this.schemaString).booleanValue() && this.isSchemasCompatible(this.schemaString, topic).booleanValue()) {
                this.registerSchema(topic, this.schemaString);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("error occured while  schema registeration " + e.getMessage());
        }
    }

    private void registerSchema(String topic, String schemaString) throws IOException, RestClientException {
        String path = String.format(REGISTER_API_PATH, topic);
        RegisterSchemaRequest schemaRequest = new RegisterSchemaRequest();
        schemaRequest.setSchema(schemaString);
        schemaRequest.setSchemaType(this.serdeFormat != null ? this.serdeFormat.toUpperCase() : null);
        RegisterSchemaResponse registerSchemaResponse = this.restUtils.getHttpResponse(schemaRequest.toJson(), path, new TypeReference<RegisterSchemaResponse>(){});
        if (registerSchemaResponse == null) {
            throw new RuntimeException("Schema Registeration failed");
        }
    }

    @NotNull
    private String getSchemaString() {
        if (this.schemaConfig != null && this.schemaConfig.isCreate().booleanValue()) {
            String schemaString = this.getSchemaDefinition();
            if (schemaString == null) {
                throw new RuntimeException("Invalid schema definition");
            }
            return schemaString;
        }
        return null;
    }

    private String getSchemaDefinition() {
        try {
            if (this.schemaConfig.getInlineSchema() != null) {
                return this.schemaConfig.getInlineSchema();
            }
            if (this.schemaConfig.getSchemaFileLocation() != null) {
                return this.parseSchemaFromJsonFile(this.schemaConfig.getSchemaFileLocation());
            }
            if (this.checkS3SchemaValidity(this.schemaConfig.getS3FileConfig())) {
                return this.getS3SchemaObject(this.schemaConfig.getS3FileConfig());
            }
        }
        catch (IOException io) {
            LOG.error(io.getMessage());
        }
        return null;
    }

    private boolean checkS3SchemaValidity(SchemaConfig.S3FileConfig s3FileConfig) throws IOException {
        return s3FileConfig.getBucketName() != null && s3FileConfig.getFileKey() != null && s3FileConfig.getRegion() != null;
    }

    private static S3Client buildS3Client(String region) {
        AwsCredentialsProviderChain credentialsProvider = AwsCredentialsProviderChain.builder().addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create()).build();
        return (S3Client)((S3ClientBuilder)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().region(Region.of((String)region))).credentialsProvider((AwsCredentialsProvider)credentialsProvider)).httpClientBuilder((SdkHttpClient.Builder)ApacheHttpClient.builder())).build();
    }

    private String getS3SchemaObject(SchemaConfig.S3FileConfig s3FileConfig) throws IOException {
        S3Client s3Client = SchemaService.buildS3Client(s3FileConfig.getRegion());
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(s3FileConfig.getBucketName()).key(s3FileConfig.getFileKey()).build();
        ResponseInputStream s3Object = s3Client.getObject(getObjectRequest);
        Map<String, Object> stringObjectMap = this.jsonUtils.getReadValue((InputStream)s3Object, new TypeReference<Map<String, Object>>(){});
        return this.jsonUtils.getJsonValue(stringObjectMap);
    }

    private String parseSchemaFromJsonFile(String location) throws IOException {
        Map jsonMap;
        try {
            jsonMap = this.jsonUtils.getReadValue(Paths.get(location, new String[0]).toFile(), Map.class);
        }
        catch (FileNotFoundException e) {
            LOG.error("Schema file not found, Error: {}", (Object)e.getMessage());
            throw new IOException("Can't proceed without schema.");
        }
        HashMap schemaMap = new HashMap();
        for (Map.Entry entry : jsonMap.entrySet()) {
            schemaMap.put(entry.getKey(), entry.getValue());
        }
        try {
            return this.jsonUtils.getJsonValue(schemaMap);
        }
        catch (Exception e) {
            LOG.error("Unable to parse schema from the provided schema file, Error: {}", (Object)e.getMessage());
            throw new IOException("Can't proceed without schema.");
        }
    }

    private static CachedSchemaRegistryClient getSchemaRegistryClient(SchemaConfig schemaConfig) {
        if (schemaConfig != null && schemaConfig.getRegistryURL() != null) {
            return new CachedSchemaRegistryClient(schemaConfig.getRegistryURL(), 100, SchemaService.getSchemaProperties(schemaConfig));
        }
        return null;
    }

    @NotNull
    private static Map getSchemaProperties(SchemaConfig schemaConfig) {
        Properties schemaProps = new Properties();
        SinkPropertyConfigurer.setSchemaCredentialsConfig(schemaConfig, schemaProps);
        Properties propertiesMap = schemaProps;
        return propertiesMap;
    }

    private Boolean isSchemaDifferent(String oldSchema, String newSchema) throws JsonProcessingException {
        return this.jsonUtils.isJsonNodeDifferent(this.jsonUtils.getJsonNode(oldSchema), this.jsonUtils.getJsonNode(newSchema));
    }

    private Boolean isSchemasCompatible(String schemaString, String topic) {
        String path = String.format(COMPATIBILITY_API_PATH, topic, this.schemaConfig.getVersion());
        try {
            RegisterSchemaRequest request = new RegisterSchemaRequest();
            request.setSchema(schemaString);
            request.setSchemaType(this.serdeFormat != null ? this.serdeFormat.toUpperCase() : null);
            CompatibilityCheckResponse compatibilityCheckResponse = this.restUtils.getHttpResponse(request.toJson(), path, new TypeReference<CompatibilityCheckResponse>(){});
            if (ObjectUtils.isEmpty((Object)compatibilityCheckResponse)) {
                return false;
            }
            return compatibilityCheckResponse.getIsCompatible();
        }
        catch (Exception ex) {
            LOG.error("Error occured in testing compatiblity " + ex.getMessage());
            return false;
        }
    }

    public static class SchemaServiceBuilder {
        private SchemaConfig schemaConfig;
        private String topic;
        private String serdeFormat;
        private RestUtils restUtils;
        private CachedSchemaRegistryClient cachedSchemaRegistryClient;

        public SchemaServiceBuilder getRegisterationAndCompatibilityService(String topic, String serdeFormat, RestUtils restUtils, SchemaConfig schemaConfig) {
            this.topic = topic;
            this.serdeFormat = serdeFormat;
            this.restUtils = restUtils;
            this.schemaConfig = schemaConfig;
            this.cachedSchemaRegistryClient = SchemaService.getSchemaRegistryClient(schemaConfig);
            return this;
        }

        public SchemaServiceBuilder getFetchSchemaService(String topic, SchemaConfig schemaConfig) {
            this.topic = topic;
            this.schemaConfig = schemaConfig;
            this.cachedSchemaRegistryClient = SchemaService.getSchemaRegistryClient(schemaConfig);
            return this;
        }

        public SchemaService build() {
            return new SchemaService(this);
        }
    }
}

