/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.dissect;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.SingleThread;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.InvalidPluginConfigurationException;
import org.opensearch.dataprepper.model.processor.AbstractProcessor;
import org.opensearch.dataprepper.model.processor.Processor;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.dissect.DissectProcessorConfig;
import org.opensearch.dataprepper.plugins.processor.dissect.Dissector;
import org.opensearch.dataprepper.plugins.processor.dissect.Fields.Field;
import org.opensearch.dataprepper.plugins.processor.mutateevent.TargetType;
import org.opensearch.dataprepper.typeconverter.TypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingleThread
@DataPrepperPlugin(name="dissect", pluginType=Processor.class, pluginConfigurationType=DissectProcessorConfig.class)
public class DissectProcessor
extends AbstractProcessor<Record<Event>, Record<Event>> {
    private static final Logger LOG = LoggerFactory.getLogger(DissectProcessor.class);
    private final DissectProcessorConfig dissectConfig;
    private final Map<String, Dissector> dissectorMap = new HashMap<String, Dissector>();
    private final Map<String, TargetType> targetTypeMap;
    private final ExpressionEvaluator expressionEvaluator;

    @DataPrepperPluginConstructor
    public DissectProcessor(PluginMetrics pluginMetrics, DissectProcessorConfig dissectConfig, ExpressionEvaluator expressionEvaluator) {
        super(pluginMetrics);
        this.dissectConfig = dissectConfig;
        this.expressionEvaluator = expressionEvaluator;
        this.targetTypeMap = dissectConfig.getTargetTypes();
        Map<String, String> patternsMap = dissectConfig.getMap();
        for (String key : patternsMap.keySet()) {
            Dissector dissector = new Dissector(patternsMap.get(key));
            this.dissectorMap.put(key, dissector);
        }
        if (dissectConfig.getDissectWhen() != null && !expressionEvaluator.isValidExpressionStatement(dissectConfig.getDissectWhen()).booleanValue()) {
            throw new InvalidPluginConfigurationException(String.format("dissect_when \"%s\" is not a valid expression statement. See https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/ for valid expression syntax", dissectConfig.getDissectWhen()));
        }
    }

    public Collection<Record<Event>> doExecute(Collection<Record<Event>> records) {
        for (Record<Event> record : records) {
            Event event = (Event)record.getData();
            try {
                String dissectWhen = this.dissectConfig.getDissectWhen();
                if (Objects.nonNull(dissectWhen) && !this.expressionEvaluator.evaluateConditional(dissectWhen, event).booleanValue()) continue;
                for (String field : this.dissectorMap.keySet()) {
                    if (!event.containsKey(field)) continue;
                    this.dissectField(event, field);
                }
            }
            catch (Exception ex) {
                LOG.atError().addMarker(DataPrepperMarkers.EVENT).addMarker(DataPrepperMarkers.NOISY).setMessage("Error dissecting the event [{}]").addArgument(record.getData()).setCause((Throwable)ex).log();
            }
        }
        return records;
    }

    private void dissectField(Event event, String field) {
        Dissector dissector = this.dissectorMap.get(field);
        boolean isDeleteSourceOnSuccessfulDissect = this.dissectConfig.isDeleteSourceRequested();
        String text = (String)event.get(field, String.class);
        if (dissector.dissectText(text)) {
            List<Field> dissectedFields = dissector.getDissectedFields();
            for (Field disectedField : dissectedFields) {
                String dissectFieldName = disectedField.getKey();
                Object dissectFieldValue = this.convertTargetType(dissectFieldName, disectedField.getValue());
                event.put(disectedField.getKey(), dissectFieldValue);
            }
            if (isDeleteSourceOnSuccessfulDissect) {
                event.delete(field);
            }
        }
    }

    private Object convertTargetType(String fieldKey, String fieldValue) {
        if (this.targetTypeMap == null) {
            return fieldValue;
        }
        try {
            if (this.targetTypeMap.containsKey(fieldKey)) {
                TypeConverter converter = this.targetTypeMap.get(fieldKey).getTargetConverter();
                return converter.convert((Object)fieldValue);
            }
            return fieldValue;
        }
        catch (NumberFormatException ex) {
            LOG.error("Unable to convert [{}] to the target type mentioned", (Object)fieldKey);
            return fieldValue;
        }
    }

    public void prepareForShutdown() {
    }

    public boolean isReadyForShutdown() {
        return true;
    }

    public void shutdown() {
    }
}

