/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.s3.common.ownership;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opensearch.dataprepper.plugins.s3.common.ownership.BucketOwnerProvider;

public class MappedBucketOwnerProvider
implements BucketOwnerProvider {
    private final Map<String, String> bucketOwnershipMap;
    private final BucketOwnerProvider fallbackProvider;

    public MappedBucketOwnerProvider(Map<String, String> bucketOwnershipMap, BucketOwnerProvider fallbackProvider) {
        this.bucketOwnershipMap = new HashMap<String, String>(Objects.requireNonNull(bucketOwnershipMap));
        this.fallbackProvider = Objects.requireNonNull(fallbackProvider);
    }

    @Override
    public Optional<String> getBucketOwner(String bucket) {
        String account = this.bucketOwnershipMap.get(bucket);
        if (account != null) {
            return Optional.of(account);
        }
        return this.fallbackProvider.getBucketOwner(bucket);
    }
}

