/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.opensearch.index;

import java.io.IOException;
import java.util.Optional;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.dataprepper.plugins.sink.opensearch.OpenSearchSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.AbstractIndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.ClusterSettingsParser;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.DynamicIndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexManager;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IndexType;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.IsmPolicyManagement;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.NoIsmPolicyManagement;
import org.opensearch.dataprepper.plugins.sink.opensearch.index.TemplateStrategy;
import org.opensearch.dataprepper.plugins.sink.opensearch.s3.S3ClientProvider;
import software.amazon.awssdk.services.s3.S3Client;

public class IndexManagerFactory {
    private static final String S3_PREFIX = "s3://";
    private final ClusterSettingsParser clusterSettingsParser;

    public IndexManagerFactory(ClusterSettingsParser clusterSettingsParser) {
        this.clusterSettingsParser = clusterSettingsParser;
    }

    public final AbstractIndexManager getIndexManager(IndexType indexType, OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, TemplateStrategy templateStrategy) {
        try {
            return (AbstractIndexManager)this.getIndexManager(indexType, openSearchClient, restHighLevelClient, openSearchSinkConfiguration, templateStrategy, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public final IndexManager getIndexManager(IndexType indexType, OpenSearchClient openSearchClient, RestHighLevelClient restHighLevelClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, TemplateStrategy templateStrategy, String indexAlias) throws IOException {
        AbstractIndexManager indexManager;
        if (indexAlias != null && this.isDynamicIndexAlias(indexAlias)) {
            return new DynamicIndexManager(indexType, openSearchClient, restHighLevelClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, this);
        }
        switch (indexType) {
            case TRACE_ANALYTICS_RAW: 
            case TRACE_ANALYTICS_RAW_PLAIN: {
                indexManager = new TraceAnalyticsRawIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            case TRACE_ANALYTICS_SERVICE_MAP: {
                indexManager = new TraceAnalyticsServiceMapIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            case OTEL_APM_SERVICE_MAP: {
                indexManager = new OTelAPMServiceMapIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            case LOG_ANALYTICS: 
            case LOG_ANALYTICS_PLAIN: {
                indexManager = new LogAnalyticsIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            case METRIC_ANALYTICS: 
            case METRIC_ANALYTICS_PLAIN: {
                indexManager = new MetricAnalyticsIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            case MANAGEMENT_DISABLED: {
                indexManager = new ManagementDisabledIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
                break;
            }
            default: {
                indexManager = new DefaultIndexManager(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, this.clusterSettingsParser, templateStrategy, indexAlias);
            }
        }
        return indexManager;
    }

    private boolean isDynamicIndexAlias(String indexAlias) {
        return indexAlias.indexOf("${") != -1;
    }

    private class ManagementDisabledIndexManager
    extends AbstractIndexManager {
        protected ManagementDisabledIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
        }

        @Override
        public void setupIndex() {
        }
    }

    private static class MetricAnalyticsIndexManager
    extends AbstractIndexManager {
        public MetricAnalyticsIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            this.ismPolicyManagementStrategy = new IsmPolicyManagement(openSearchClient, restHighLevelClient, "metrics-policy", "metrics-policy-with-ism-template.json", "metrics-policy-no-ism-template.json");
        }
    }

    private static class LogAnalyticsIndexManager
    extends AbstractIndexManager {
        public LogAnalyticsIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            this.ismPolicyManagementStrategy = new IsmPolicyManagement(openSearchClient, restHighLevelClient, "logs-policy", "logs-policy-with-ism-template.json", "logs-policy-no-ism-template.json");
        }
    }

    private static class OTelAPMServiceMapIndexManager
    extends AbstractIndexManager {
        public OTelAPMServiceMapIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            this.ismPolicyManagementStrategy = new IsmPolicyManagement(openSearchClient, restHighLevelClient, "otel-v2-apm-service-map-policy", "otel-v2-apm-service-map-policy-with-ism-template.json", "otel-v2-apm-service-map-policy-no-ism-template.json");
        }
    }

    private static class TraceAnalyticsServiceMapIndexManager
    extends AbstractIndexManager {
        public TraceAnalyticsServiceMapIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            this.ismPolicyManagementStrategy = new NoIsmPolicyManagement(openSearchClient, restHighLevelClient);
        }
    }

    private static class TraceAnalyticsRawIndexManager
    extends AbstractIndexManager {
        public TraceAnalyticsRawIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            this.ismPolicyManagementStrategy = new IsmPolicyManagement(openSearchClient, restHighLevelClient, "raw-span-policy", "raw-span-policy-with-ism-template.json", "raw-span-policy-no-ism-template.json");
        }
    }

    private static class DefaultIndexManager
    extends AbstractIndexManager {
        private static final String POLICY_NAME_SUFFIX = "-policy";

        public DefaultIndexManager(RestHighLevelClient restHighLevelClient, OpenSearchClient openSearchClient, OpenSearchSinkConfiguration openSearchSinkConfiguration, ClusterSettingsParser clusterSettingsParser, TemplateStrategy templateStrategy, String indexAlias) {
            super(restHighLevelClient, openSearchClient, openSearchSinkConfiguration, clusterSettingsParser, templateStrategy, indexAlias);
            Optional<String> ismPolicyFile = openSearchSinkConfiguration.getIndexConfiguration().getIsmPolicyFile();
            if (ismPolicyFile.isPresent()) {
                S3Client s3Client = null;
                if (ismPolicyFile.get().startsWith(IndexManagerFactory.S3_PREFIX)) {
                    String s3AwsRegion = openSearchSinkConfiguration.getIndexConfiguration().getS3AwsRegion();
                    String s3AwsStsRoleArn = openSearchSinkConfiguration.getIndexConfiguration().getS3AwsStsRoleArn();
                    String s3AwsStsExternalId = openSearchSinkConfiguration.getIndexConfiguration().getS3AwsStsExternalId();
                    S3ClientProvider clientProvider = new S3ClientProvider(s3AwsRegion, s3AwsStsRoleArn, s3AwsStsExternalId);
                    s3Client = clientProvider.buildS3Client();
                }
                String indexPolicyName = this.getIndexPolicyName();
                this.ismPolicyManagementStrategy = new IsmPolicyManagement(openSearchClient, restHighLevelClient, indexPolicyName, ismPolicyFile.get(), s3Client);
            } else {
                this.ismPolicyManagementStrategy = new NoIsmPolicyManagement(openSearchClient, restHighLevelClient);
            }
        }

        private String getIndexPolicyName() {
            return this.indexPrefix + POLICY_NAME_SUFFIX;
        }
    }
}

