/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import com.arpnetworking.metrics.prometheus.Types;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.model.metric.ExponentialHistogram;
import org.opensearch.dataprepper.model.metric.Gauge;
import org.opensearch.dataprepper.model.metric.Histogram;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.model.metric.Quantile;
import org.opensearch.dataprepper.model.metric.Sum;
import org.opensearch.dataprepper.model.metric.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusTimeSeries {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusTimeSeries.class);
    private static final int APPROXIMATE_PROTOBUF_LABEL_OVERHEAD = 8;
    private static final int APPROXIMATE_PROTOBUF_SAMPLE_OVERHEAD = 2;
    private static final String UNDERSCORE = "_";
    private static final String TOTAL_SUFFIX = "_total";
    private static final String RATIO_SUFFIX = "_ratio";
    private static final String COUNT_SUFFIX = "_count";
    private static final String SUM_SUFFIX = "_sum";
    private static final String MIN_SUFFIX = "_min";
    private static final String MAX_SUFFIX = "_max";
    private static final String BUCKET_SUFFIX = "_bucket";
    private static final String ZERO_COUNT_SUFFIX = "_zero_count";
    private static final String ZERO_THRESHOLD_SUFFIX = "_zero_threshold";
    private static final String NAME_LABEL = "__name__";
    private static final String QUANTILE_LABEL = "quantile";
    private static final String LE_LABEL = "le";
    private static final String GE_LABEL = "ge";
    private static final String PLUS_INF = "+Inf";
    private static final String RESOURCE_PREFIX = "resource_";
    private static final String SCOPE_PREFIX = "scope_";
    private static final Map<String, String> otelToPrometheusUnitsMap = Map.ofEntries(Map.entry("d", "days"), Map.entry("h", "hours"), Map.entry("min", "minutes"), Map.entry("s", "seconds"), Map.entry("ms", "milliseconds"), Map.entry("us", "microseconds"), Map.entry("ns", "nanoseconds"), Map.entry("By", "bytes"), Map.entry("KiBy", "kibibytes"), Map.entry("MiBy", "mebibytes"), Map.entry("GiBy", "gibibytes"), Map.entry("TiBy", "tibibytes"), Map.entry("KBy", "kilobytes"), Map.entry("MBy", "megabytes"), Map.entry("GBy", "gigabytes"), Map.entry("TBy", "terabytes"), Map.entry("V", "volts"), Map.entry("A", "amperes"), Map.entry("J", "joules"), Map.entry("W", "watts"), Map.entry("g", "grams"), Map.entry("Cel", "celsius"), Map.entry("Hz", "hertz"), Map.entry("%", "percent"), Map.entry("m", "meters"));
    private final String metricName;
    private long timestamp;
    private boolean sanitizeNames;
    private List<Types.TimeSeries> timeSeriesList;
    private List<Types.Label> baseLabels;
    private long baseLabelsSize;
    private int seriesSize;

    public PrometheusTimeSeries(Metric metric, boolean sanitizeNames) throws Exception {
        this.sanitizeNames = sanitizeNames;
        this.metricName = sanitizeNames ? PrometheusTimeSeries.sanitizeMetricName(metric) : metric.getName();
        String time = metric.getTime();
        String startTime = metric.getStartTime();
        this.timestamp = time != null ? PrometheusTimeSeries.getTimestampVal(time) : PrometheusTimeSeries.getTimestampVal(startTime);
        this.timeSeriesList = new ArrayList<Types.TimeSeries>();
        this.baseLabels = new ArrayList<Types.Label>();
        this.seriesSize = 0;
        this.baseLabelsSize = this.processAttributes(metric.getAttributes(), "");
        this.baseLabelsSize += this.processResourceAndScopeAttributes(metric);
        if (metric instanceof Gauge) {
            this.addGaugeMetric((Gauge)metric);
        } else if (metric instanceof Sum) {
            this.addSumMetric((Sum)metric);
        } else if (metric instanceof Summary) {
            this.addSummaryMetric((Summary)metric);
        } else if (metric instanceof Histogram) {
            this.addHistogramMetric((Histogram)metric);
        } else if (metric instanceof ExponentialHistogram) {
            this.addExponentialHistogramMetric((ExponentialHistogram)metric);
        } else {
            throw new RuntimeException("Unknown Metric");
        }
    }

    public String getMetricKey() {
        StringBuilder result = new StringBuilder();
        for (Types.Label l : this.timeSeriesList.get(0).getLabelsList()) {
            result.append(l.getName()).append(" ").append(l.getValue()).append(" ");
        }
        return result.toString();
    }

    public String getMetricName() {
        return this.metricName;
    }

    private long processAttributes(Map<String, Object> attributesMap, String prefix) {
        long size = 0L;
        if (attributesMap != null) {
            for (Map.Entry<String, Object> entry : attributesMap.entrySet()) {
                String key = prefix.isEmpty() ? entry.getKey() : prefix + entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    this.processAttributes((Map)value, key + UNDERSCORE);
                    continue;
                }
                size += this.addLabel(key, value);
            }
        }
        return size;
    }

    private long processResourceAndScopeAttributes(Metric metric) {
        long size = 0L;
        try {
            if (metric.getResource() != null) {
                Map resourceAttributes = (Map)metric.getResource().get("attributes");
                size += this.processAttributes(resourceAttributes, RESOURCE_PREFIX);
            }
            if (metric.getScope() != null) {
                Map scopeAttributes = (Map)metric.getScope().get("attributes");
                size += this.processAttributes(scopeAttributes, SCOPE_PREFIX);
            }
        }
        catch (Exception e) {
            LOG.warn(DataPrepperMarkers.NOISY, "Failed to get resource/scope attributes", (Throwable)e);
        }
        return size;
    }

    private long addLabel(String name, Object value) {
        if (this.sanitizeNames) {
            name = PrometheusTimeSeries.sanitizeLabelName(name);
        }
        return this.addLabelSanitized(name, value);
    }

    private long addLabelSanitized(String name, Object value) {
        String valueStr = value instanceof String ? (String)value : String.valueOf(value);
        Types.Label label = Types.Label.newBuilder().setName(name).setValue(valueStr).build();
        this.baseLabels.add(label);
        return this.estimateLabelSize(name, valueStr);
    }

    private long estimateLabelSize(String name, String value) {
        return (long)name.length() + (long)value.length() + 8L;
    }

    private void addTimeSeries(String labelName, String labelValue, Double sampleValue) {
        this.addTimeSeries(labelName, labelValue, null, null, sampleValue);
    }

    private void addTimeSeries(String labelName, String labelValue, String labelName2, String labelValue2, Double sampleValue) {
        ArrayList<Types.Label> labels = new ArrayList<Types.Label>(this.baseLabels.size() + 2);
        labels.addAll(this.baseLabels);
        labels.add(Types.Label.newBuilder().setName(labelName).setValue(labelValue).build());
        if (labelName2 != null) {
            labels.add(Types.Label.newBuilder().setName(labelName2).setValue(labelValue2).build());
        }
        Collections.sort(labels, Comparator.comparing(Types.Label::getName));
        Types.TimeSeries ts = Types.TimeSeries.newBuilder().addAllLabels(labels).addSamples(Types.Sample.newBuilder().setValue(sampleValue.doubleValue()).setTimestamp(this.timestamp).build()).build();
        this.seriesSize += ts.getSerializedSize();
        this.timeSeriesList.add(ts);
    }

    public List<Types.TimeSeries> getTimeSeriesList() {
        return this.timeSeriesList;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public int getSize() {
        return this.seriesSize;
    }

    public void addSumMetric(Sum sum) {
        this.addTimeSeries(NAME_LABEL, this.metricName, sum.getValue());
    }

    public void addGaugeMetric(Gauge gauge) {
        this.addTimeSeries(NAME_LABEL, this.metricName, gauge.getValue());
    }

    public void addSummaryMetric(Summary summary) {
        this.addTimeSeries(NAME_LABEL, this.metricName + COUNT_SUFFIX, (double)summary.getCount());
        this.addTimeSeries(NAME_LABEL, this.metricName + SUM_SUFFIX, (double)summary.getSum());
        List quantiles = summary.getQuantiles();
        for (Quantile quantile : quantiles) {
            this.addTimeSeries(NAME_LABEL, this.metricName, QUANTILE_LABEL, quantile.getQuantile().toString(), (double)quantile.getValue());
        }
    }

    public void addHistogramMetric(Histogram histogram) {
        Double max;
        this.addTimeSeries(NAME_LABEL, this.metricName + COUNT_SUFFIX, (double)histogram.getCount());
        this.addTimeSeries(NAME_LABEL, this.metricName + SUM_SUFFIX, (double)histogram.getSum());
        Double min = histogram.getMin();
        if (min != null) {
            this.addTimeSeries(NAME_LABEL, this.metricName + MIN_SUFFIX, min);
        }
        if ((max = histogram.getMax()) != null) {
            this.addTimeSeries(NAME_LABEL, this.metricName + MAX_SUFFIX, max);
        }
        List explicitBounds = histogram.getExplicitBoundsList();
        List bucketCounts = histogram.getBucketCountsList();
        if (explicitBounds != null && bucketCounts != null) {
            int lastIndex = bucketCounts.size() - 1;
            for (int i = 0; i < bucketCounts.size(); ++i) {
                String labelValue = i == lastIndex ? PLUS_INF : ((Double)explicitBounds.get(i)).toString();
                this.addTimeSeries(NAME_LABEL, this.metricName + BUCKET_SUFFIX, LE_LABEL, labelValue, (double)((Long)bucketCounts.get(i)));
            }
        }
    }

    public void addExponentialHistogramMetric(ExponentialHistogram histogram) {
        boolean negativeBucketsPresent;
        Integer scale;
        Double zeroThreshold;
        this.addTimeSeries(NAME_LABEL, this.metricName + COUNT_SUFFIX, (double)histogram.getCount());
        this.addTimeSeries(NAME_LABEL, this.metricName + SUM_SUFFIX, (double)histogram.getSum());
        Long zeroCount = histogram.getZeroCount();
        if (zeroCount != null) {
            this.addTimeSeries(NAME_LABEL, this.metricName + ZERO_COUNT_SUFFIX, (double)zeroCount);
        }
        if ((zeroThreshold = histogram.getZeroThreshold()) != null) {
            this.addTimeSeries(NAME_LABEL, this.metricName + ZERO_THRESHOLD_SUFFIX, zeroThreshold);
        }
        if ((scale = histogram.getScale()) != null) {
            this.addTimeSeries(NAME_LABEL, this.metricName + ZERO_THRESHOLD_SUFFIX, (double)scale);
        }
        List positiveBucketCounts = histogram.getPositive();
        Integer positiveOffset = histogram.getPositiveOffset();
        List negativeBucketCounts = histogram.getNegative();
        Integer negativeOffset = histogram.getPositiveOffset();
        boolean positiveBucketsPresent = positiveBucketCounts != null && positiveOffset != null;
        boolean bl = negativeBucketsPresent = negativeBucketCounts != null && negativeOffset != null;
        if (positiveBucketsPresent || negativeBucketsPresent) {
            double bound;
            int i;
            if (positiveBucketsPresent) {
                for (i = 0; i < positiveBucketCounts.size(); ++i) {
                    bound = PrometheusTimeSeries.calculateBucketBound(i + positiveOffset + 1, scale);
                    this.addTimeSeries(NAME_LABEL, this.metricName + BUCKET_SUFFIX, LE_LABEL, Double.toString(bound), (double)((Long)positiveBucketCounts.get(i)));
                }
            }
            if (negativeBucketsPresent) {
                for (i = 0; i < negativeBucketCounts.size(); ++i) {
                    bound = -PrometheusTimeSeries.calculateBucketBound(i + negativeOffset + 1, scale);
                    this.addTimeSeries(NAME_LABEL, this.metricName + BUCKET_SUFFIX, GE_LABEL, Double.toString(bound), (double)((Long)negativeBucketCounts.get(i)));
                }
            }
        }
    }

    private static double calculateBucketBound(int index, int scale) {
        return Math.pow(2.0, (double)index * Math.pow(2.0, -scale));
    }

    static String sanitizeMetricName(Metric metric) {
        String[] unitSplit;
        String suffix;
        String name = metric.getName();
        String unit = metric.getUnit();
        boolean isGauge = metric.getKind().equals(Metric.KIND.GAUGE.toString());
        boolean isCounter = metric.getKind().equals(Metric.KIND.SUM.toString()) && ((Sum)metric).isMonotonic() && ((Sum)metric).getAggregationTemporality().equals("AGGREGATION_TEMPORALITY_CUMULATIVE");
        StringBuilder metricNameBuilder = new StringBuilder(PrometheusTimeSeries.sanitizeName(name, true, false));
        String string = suffix = isCounter ? TOTAL_SUFFIX : "";
        if (unit.startsWith("{")) {
            return metricNameBuilder.append(suffix).toString();
        }
        if ("1".equals(unit) && isGauge) {
            return metricNameBuilder.append(RATIO_SUFFIX).toString();
        }
        String mappedUnit = otelToPrometheusUnitsMap.get(unit);
        if (mappedUnit != null) {
            return metricNameBuilder.append(UNDERSCORE).append(mappedUnit).append(suffix).toString();
        }
        if (unit.contains("/") && (unitSplit = unit.split("/", 2)).length == 2) {
            String unit1 = otelToPrometheusUnitsMap.get(unitSplit[0]);
            String unit2 = otelToPrometheusUnitsMap.get(unitSplit[1]);
            if (unit1 != null && unit2 != null) {
                return metricNameBuilder.append(UNDERSCORE).append(unit1).append(UNDERSCORE).append(unit2).append(suffix).toString();
            }
        }
        if (!"1".equals(unit)) {
            metricNameBuilder.append(UNDERSCORE).append(unit);
        }
        return metricNameBuilder.append(suffix).toString();
    }

    static String sanitizeLabelName(String name) {
        return PrometheusTimeSeries.sanitizeName(name, false, true);
    }

    static String sanitizeName(String name, boolean allowColon, boolean isLabel) {
        StringBuilder sb = new StringBuilder(name.length());
        int prevChar = 0;
        for (int i = 0; i < name.length(); ++i) {
            char curChar = PrometheusTimeSeries.sanitizeChar(name.charAt(i), i == 0, allowColon);
            if (isLabel || curChar != '_' || prevChar != 95) {
                sb.append(curChar);
            }
            prevChar = curChar;
        }
        String result = sb.toString();
        if (!isLabel) {
            int start;
            int end = result.length();
            for (start = 0; start < end && result.charAt(start) == '_'; ++start) {
            }
            while (end > start && result.charAt(end - 1) == '_') {
                --end;
            }
            result = result.substring(start, end);
        }
        return result;
    }

    private static char sanitizeChar(char c, boolean isFirst, boolean allowColon) {
        if (allowColon && c == ':') {
            return c;
        }
        if (isFirst) {
            return Character.isLetter(c) ? c : (char)'_';
        }
        return Character.isLetterOrDigit(c) ? c : (char)'_';
    }

    private static long getTimestampVal(String time) throws Exception {
        return Instant.parse(time).toEpochMilli();
    }
}

