/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.opensearch.dataprepper.common.sink.DefaultSinkOutputStrategy;
import org.opensearch.dataprepper.common.sink.LockStrategy;
import org.opensearch.dataprepper.common.sink.ReentrantLockStrategy;
import org.opensearch.dataprepper.common.sink.SinkBuffer;
import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.common.sink.SinkFlushContext;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusHttpSender;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBuffer;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferEntry;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkBufferWriter;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkFlushContext;

public class PrometheusSinkService
extends DefaultSinkOutputStrategy {
    static final String PLUGIN_NAME = "prometheus";
    public static final String PROMETHEUS_SINK_RECORDS_SUCCESS_COUNTER = "prometheusSinkRecordsNumberOfSuccessful";
    public static final String PROMETHEUS_SINK_RECORDS_FAILED_COUNTER = "prometheusSinkRecordsNumberOfFailed";
    private final PrometheusHttpSender httpSender;
    private final PipelineDescription pipelineDescription;
    private final List<Record<Event>> dlqRecords;
    private final boolean sanitizeNames;
    private HeadlessPipeline dlqPipeline;
    private boolean dropIfNoDLQConfigured;
    private String pluginName;

    public PrometheusSinkService(PrometheusSinkConfiguration prometheusSinkConfiguration, SinkMetrics sinkMetrics, PrometheusHttpSender httpSender, PipelineDescription pipelineDescription) {
        super((LockStrategy)new ReentrantLockStrategy(), (SinkBuffer)new PrometheusSinkBuffer(prometheusSinkConfiguration.getThresholdConfig().getMaxEvents(), prometheusSinkConfiguration.getThresholdConfig().getMaxRequestSizeBytes(), prometheusSinkConfiguration.getThresholdConfig().getFlushIntervalMs(), new PrometheusSinkBufferWriter(prometheusSinkConfiguration, sinkMetrics)), (SinkFlushContext)new PrometheusSinkFlushContext(httpSender), sinkMetrics);
        this.sanitizeNames = prometheusSinkConfiguration.getSanitizeNames();
        this.dropIfNoDLQConfigured = false;
        this.dlqRecords = new ArrayList<Record<Event>>();
        this.httpSender = httpSender;
        this.pipelineDescription = pipelineDescription;
    }

    public void addFailedEventsToDLQ(List<Event> events, Throwable ex) {
        for (Event event : events) {
            this.dlqRecords.add((Record<Event>)new Record((Object)event));
        }
    }

    public SinkBufferEntry getSinkBufferEntry(Event event) throws Exception {
        return new PrometheusSinkBufferEntry(event, this.sanitizeNames);
    }

    public void setDlqPipeline(HeadlessPipeline pipeline) {
        this.dlqPipeline = pipeline;
    }

    public void flushDlqList() {
        if (this.dlqRecords.isEmpty()) {
            return;
        }
        if (this.dlqPipeline != null) {
            this.dlqPipeline.sendEvents(this.dlqRecords);
        }
        this.dlqRecords.clear();
    }

    public void output(Collection<Record<Event>> records) {
        this.execute(records);
    }

    public void addFailedEventsToDlq(List<Event> failedEvents, Throwable ex, int statusCode) {
        for (Event event : failedEvents) {
            if (this.dlqPipeline == null) {
                event.getEventHandle().release(this.dropIfNoDLQConfigured);
                continue;
            }
            event.updateFailureMetadata().with("statusCode", (Object)statusCode).with("pluginName", (Object)PLUGIN_NAME).with("pipelineName", (Object)this.pipelineDescription.getPipelineName());
            if (ex != null) {
                event.updateFailureMetadata().with("message", (Object)ex.getMessage());
            }
            this.dlqRecords.add((Record<Event>)new Record((Object)event));
        }
    }
}

