/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.service;

import org.opensearch.dataprepper.common.sink.SinkBufferEntry;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventType;
import org.opensearch.dataprepper.model.metric.Metric;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusTimeSeries;

public class PrometheusSinkBufferEntry
implements SinkBufferEntry {
    final Event event;
    final PrometheusTimeSeries timeSeries;

    public PrometheusSinkBufferEntry(Event event, boolean sanitizeNames) throws Exception {
        this.event = event;
        this.timeSeries = this.getTimeSeriesForEvent(sanitizeNames);
    }

    public PrometheusTimeSeries getTimeSeries() {
        return this.timeSeries;
    }

    public long getEstimatedSize() {
        return this.timeSeries.getSize();
    }

    public boolean exceedsMaxEventSizeThreshold() {
        return false;
    }

    public Event getEvent() {
        return this.event;
    }

    private PrometheusTimeSeries getTimeSeriesForEvent(boolean sanitizeNames) throws Exception {
        if (this.event.getMetadata().getEventType().equals(EventType.METRIC.toString())) {
            return new PrometheusTimeSeries((Metric)this.event, sanitizeNames);
        }
        throw new RuntimeException("Not metric type");
    }
}

