/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus.configuration;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.NotNull;
import java.time.Duration;
import org.hibernate.validator.constraints.time.DurationMax;
import org.hibernate.validator.constraints.time.DurationMin;
import org.opensearch.dataprepper.aws.api.AwsConfig;
import org.opensearch.dataprepper.plugins.codec.CompressionOption;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkThresholdConfig;

public class PrometheusSinkConfiguration {
    static final int DEFAULT_MAX_RETRIES = 5;
    public static final CompressionOption DEFAULT_ENCODING = CompressionOption.SNAPPY;
    private static final String DEFAULT_CONTENT_TYPE = "application/x-protobuf";
    static final String DEFAULT_REMOTE_WRITE_VERSION = "0.1.0";
    private static final Duration DEFAULT_REQUEST_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_CONNECTION_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_IDLE_TIMEOUT = Duration.ofSeconds(60L);
    private static final Duration DEFAULT_OUT_OF_ORDER_TIME_WINDOW = Duration.ofSeconds(10L);
    @JsonProperty(value="aws")
    @NotNull
    @Valid
    private AwsConfig awsConfig;
    @NotNull
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="out_of_order_time_window")
    private Duration outOfOrderTimeWindow = DEFAULT_OUT_OF_ORDER_TIME_WINDOW;
    @JsonProperty(value="max_retries")
    private int maxRetries = 5;
    @JsonProperty(value="threshold")
    private PrometheusSinkThresholdConfig thresholdConfig;
    @JsonProperty(value="encoding")
    private CompressionOption encoding = DEFAULT_ENCODING;
    @JsonProperty(value="content_type")
    private String contentType = "application/x-protobuf";
    @JsonProperty(value="remote_write_version")
    private String remoteWriteVersion = "0.1.0";
    @JsonProperty(value="request_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=600L)
    private @DurationMin(seconds=1L) @DurationMax(seconds=600L) Duration requestTimeout = DEFAULT_REQUEST_TIMEOUT;
    @JsonProperty(value="connection_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=600L)
    private @DurationMin(seconds=1L) @DurationMax(seconds=600L) Duration connectionTimeout = DEFAULT_CONNECTION_TIMEOUT;
    @JsonProperty(value="idle_timeout")
    @DurationMin(seconds=1L)
    @DurationMax(seconds=600L)
    private @DurationMin(seconds=1L) @DurationMax(seconds=600L) Duration idleTimeout = DEFAULT_IDLE_TIMEOUT;
    @JsonProperty(value="sanitize_names")
    private boolean sanitizeNames = true;

    public boolean getSanitizeNames() {
        return this.sanitizeNames;
    }

    public String getUrl() {
        return this.url;
    }

    public PrometheusSinkThresholdConfig getThresholdConfig() {
        if (this.thresholdConfig == null) {
            return new PrometheusSinkThresholdConfig();
        }
        return this.thresholdConfig;
    }

    public AwsConfig getAwsConfig() {
        return this.awsConfig;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public CompressionOption getEncoding() {
        return this.encoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Duration getOutOfOrderTimeWindow() {
        return this.outOfOrderTimeWindow;
    }

    public String getRemoteWriteVersion() {
        return this.remoteWriteVersion;
    }

    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    public Duration getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @AssertTrue(message="encoding or content_type or remote_write_version is incorrect.")
    @AssertTrue(message="encoding or content_type or remote_write_version is incorrect.") boolean isValidConfig() {
        return this.url.startsWith("https://") && this.encoding == CompressionOption.SNAPPY && this.contentType.equals(DEFAULT_CONTENT_TYPE) && this.remoteWriteVersion.equals(DEFAULT_REMOTE_WRITE_VERSION);
    }
}

