/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.prometheus;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collection;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.common.sink.DefaultSinkMetrics;
import org.opensearch.dataprepper.common.sink.SinkMetrics;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.annotations.Experimental;
import org.opensearch.dataprepper.model.configuration.PipelineDescription;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.AbstractSink;
import org.opensearch.dataprepper.model.sink.Sink;
import org.opensearch.dataprepper.plugins.sink.prometheus.PrometheusHttpSender;
import org.opensearch.dataprepper.plugins.sink.prometheus.configuration.PrometheusSinkConfiguration;
import org.opensearch.dataprepper.plugins.sink.prometheus.service.PrometheusSinkService;

@Experimental
@DataPrepperPlugin(name="prometheus", pluginType=Sink.class, pluginConfigurationType=PrometheusSinkConfiguration.class)
public class PrometheusSink
extends AbstractSink<Record<Event>> {
    private volatile boolean sinkInitialized = false;
    private final PrometheusSinkService prometheusSinkService;
    private final PrometheusHttpSender httpSender;
    private final SinkMetrics sinkMetrics;

    @DataPrepperPluginConstructor
    public PrometheusSink(PluginSetting pluginSetting, PluginMetrics pluginMetrics, PipelineDescription pipelineDescription, PrometheusSinkConfiguration prometheusSinkConfiguration, AwsCredentialsSupplier awsCredentialsSupplier) {
        super(pluginSetting);
        this.sinkMetrics = new DefaultSinkMetrics(pluginMetrics, "Metric");
        this.httpSender = new PrometheusHttpSender(awsCredentialsSupplier, prometheusSinkConfiguration, this.sinkMetrics);
        this.prometheusSinkService = new PrometheusSinkService(prometheusSinkConfiguration, this.sinkMetrics, this.httpSender, pipelineDescription);
    }

    public boolean isReady() {
        return this.sinkInitialized;
    }

    public void doInitialize() {
        this.sinkInitialized = true;
        this.prometheusSinkService.setDlqPipeline(this.getFailurePipeline());
    }

    @VisibleForTesting
    void setDlqPipeline(HeadlessPipeline dlqPipeline) {
        this.prometheusSinkService.setDlqPipeline(dlqPipeline);
    }

    public void doOutput(Collection<Record<Event>> records) {
        this.prometheusSinkService.output(records);
    }
}

