/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.mutateevent;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.dataprepper.model.annotations.ConditionalRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;

@ConditionalRequired(value={@ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="use_source_key", value="false")}, thenExpect={@ConditionalRequired.SchemaProperty(field="key")}), @ConditionalRequired.IfThenElse(ifFulfilled={@ConditionalRequired.SchemaProperty(field="flatten", value="true")}, thenExpect={@ConditionalRequired.SchemaProperty(field="flattened_element")})})
@JsonPropertyOrder
@JsonClassDescription(value="The <code>list_to_map</code> processor converts a list of objects from an event, where each object contains a <code>key</code> field, into a map of target keys.")
public class ListToMapProcessorConfig {
    @NotEmpty
    @NotNull
    @JsonProperty(value="source")
    @JsonPropertyDescription(value="The list of objects with <code>key</code> fields to be converted into keys for the generated map.")
    private String source;
    @JsonProperty(value="target")
    @JsonPropertyDescription(value="The target for the generated map. When not specified, the generated map will be placed in the root node.")
    private String target = null;
    @JsonProperty(value="use_source_key")
    @JsonPropertyDescription(value="When <code>true</code>, keys in the generated map will use original keys from the source. Default is <code>false</code>.")
    private boolean useSourceKey = false;
    @JsonProperty(value="key")
    @JsonPropertyDescription(value="The key of the fields to be extracted as keys in the generated mappings. Must be specified if <code>use_source_key</code> is <code>false</code>.")
    private String key;
    @JsonProperty(value="value_key")
    @JsonPropertyDescription(value="When specified, values given a <code>value_key</code> in objects contained in the source list will be extracted and converted into the value specified by this option based on the generated map. When not specified, objects contained in the source list retain their original value when mapped.")
    @ExampleValues(value={@ExampleValues.Example(value="value", description="In each list object, 'value' will be extracted and used as the value in the generated map.")})
    private String valueKey = null;
    @JsonProperty(value="extract_value")
    @JsonPropertyDescription(value="When <code>true</code>, object values from the source list will be extracted and added to the generated map. When <code>false</code>, object values from the source list are added to the generated map as they appear in the source list. Default is <code>false</code>")
    private boolean extractValue = false;
    @NotNull
    @JsonProperty(value="flatten", defaultValue="false")
    @JsonPropertyDescription(value="When <code>true</code>, values in the generated map output flatten into single items based on the <code>flattened_element</code>. Otherwise, objects mapped to values from the generated map appear as lists. Default is <code>false</code>.")
    private boolean flatten = false;
    @NotNull
    @JsonProperty(value="flattened_element", defaultValue="first")
    @JsonPropertyDescription(value="The element to keep, either <code>first</code> or <code>last</code>, when <code>flatten</code> is set to <code>true</code>.")
    private FlattenedElement flattenedElement = FlattenedElement.FIRST;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A list of tags to add to the event metadata when the event fails to process.")
    private List<String> tagsOnFailure;
    @JsonProperty(value="list_to_map_when")
    @JsonPropertyDescription(value="A <a href=\"https://opensearch.org/docs/latest/data-prepper/pipelines/expression-syntax/\">conditional expression</a>, such as <code>/some-key == \"test\"</code>, that will be evaluated to determine whether the processor will be run on the event. By default, all events will be processed unless otherwise stated.")
    @ExampleValues(value={@ExampleValues.Example(value="/some-key == \"test\"", description="The operation will run when the value of the key is 'test'.")})
    private String listToMapWhen;

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public String getKey() {
        return this.key;
    }

    public String getValueKey() {
        return this.valueKey;
    }

    public boolean getUseSourceKey() {
        return this.useSourceKey;
    }

    public boolean getExtractValue() {
        return this.extractValue;
    }

    public boolean getFlatten() {
        return this.flatten;
    }

    public String getListToMapWhen() {
        return this.listToMapWhen;
    }

    public FlattenedElement getFlattenedElement() {
        return this.flattenedElement;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    public static enum FlattenedElement {
        FIRST("first"),
        LAST("last");

        private final String name;
        private static final Map<String, FlattenedElement> ACTIONS_MAP;

        private FlattenedElement(String name) {
            this.name = name.toLowerCase();
        }

        @JsonCreator
        static FlattenedElement fromOptionValue(String option) {
            return ACTIONS_MAP.get(option);
        }

        @JsonValue
        public String getOptionValue() {
            return this.name;
        }

        static {
            ACTIONS_MAP = Arrays.stream(FlattenedElement.values()).collect(Collectors.toMap(value -> value.name, value -> value));
        }
    }
}

