/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.otel.common;

import io.opentelemetry.proto.trace.v1.Span;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.trace.Span;
import org.opensearch.dataprepper.plugins.otel.common.AwsServiceMappingsProvider;
import org.opensearch.dataprepper.plugins.otel.common.RemoteOperationAndService;
import org.opensearch.dataprepper.plugins.otel.common.RemoteOperationAndServiceProviders;
import org.opensearch.dataprepper.plugins.otel.common.ServiceAddressPortAttributesProvider;
import org.opensearch.dataprepper.plugins.otel.common.ServiceEnvironmentProviders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OTelSpanDerivationUtil {
    public static final String DERIVED_FAULT_ATTRIBUTE = "derived.fault";
    public static final String DERIVED_ERROR_ATTRIBUTE = "derived.error";
    public static final String DERIVED_OPERATION_ATTRIBUTE = "derived.operation";
    public static final String DERIVED_ENVIRONMENT_ATTRIBUTE = "derived.environment";
    public static final String DERIVED_REMOTE_SERVICE_ATTRIBUTE = "derived.remote_service";
    private static final Logger LOG = LoggerFactory.getLogger(OTelSpanDerivationUtil.class);
    private static final String SERVICE_MAPPINGS_FILE = "service_mappings";

    public static void deriveServerSpanAttributes(List<Span> spans) {
        if (spans == null) {
            return;
        }
        for (Span span : spans) {
            if (span == null || !OTelSpanDerivationUtil.isServerSpan(span)) continue;
            OTelSpanDerivationUtil.deriveAttributesForSpan(span);
        }
    }

    private static boolean isServerSpan(Span span) {
        return Span.SpanKind.SPAN_KIND_SERVER.name().equals(span.getKind());
    }

    private static boolean isClientSpan(Span span) {
        return Span.SpanKind.SPAN_KIND_CLIENT.name().equals(span.getKind());
    }

    private static boolean isProducerSpan(Span span) {
        return Span.SpanKind.SPAN_KIND_PRODUCER.name().equals(span.getKind());
    }

    private static void putAttribute(Span span, String key, Object value) {
        HashMap<String, Object> attributes = span.getAttributes();
        attributes = attributes == null ? new HashMap<String, Object>() : new HashMap(attributes);
        attributes.put(key, value);
        span.put("attributes", attributes);
    }

    public static void deriveAttributesForSpan(Span span) {
        try {
            Map spanAttributes = span.getAttributes();
            ErrorFaultResult errorFault = OTelSpanDerivationUtil.computeErrorAndFault(span.getStatus(), spanAttributes);
            String operationName = null;
            if (OTelSpanDerivationUtil.isServerSpan(span)) {
                operationName = OTelSpanDerivationUtil.computeOperationName(span.getName(), spanAttributes);
            } else if (OTelSpanDerivationUtil.isClientSpan(span) || OTelSpanDerivationUtil.isProducerSpan(span)) {
                RemoteOperationAndService remoteOperationAndService = OTelSpanDerivationUtil.computeRemoteOperationAndService(spanAttributes);
                operationName = remoteOperationAndService.getOperation();
                OTelSpanDerivationUtil.putAttribute(span, DERIVED_REMOTE_SERVICE_ATTRIBUTE, remoteOperationAndService.getService());
            }
            String environment = OTelSpanDerivationUtil.computeEnvironment(spanAttributes);
            OTelSpanDerivationUtil.putAttribute(span, DERIVED_FAULT_ATTRIBUTE, String.valueOf(errorFault.fault));
            OTelSpanDerivationUtil.putAttribute(span, DERIVED_ERROR_ATTRIBUTE, String.valueOf(errorFault.error));
            if (operationName != null) {
                OTelSpanDerivationUtil.putAttribute(span, DERIVED_OPERATION_ATTRIBUTE, operationName);
            }
            OTelSpanDerivationUtil.putAttribute(span, DERIVED_ENVIRONMENT_ATTRIBUTE, environment);
            LOG.debug("Derived attributes for SERVER span {}: fault={}, error={}, operation={}, environment={}", new Object[]{span.getSpanId(), errorFault.fault, errorFault.error, operationName, environment});
        }
        catch (Exception e) {
            LOG.warn("Failed to derive attributes for span {}: {}", new Object[]{span.getSpanId(), e.getMessage(), e});
        }
    }

    public static ErrorFaultResult computeErrorAndFault(Object spanStatus, Map<String, Object> spanAttributes) {
        if (spanAttributes != null) {
            Integer httpStatusCode;
            Object httpStatusObj = spanAttributes.get("http.response.status_code");
            if (httpStatusObj == null) {
                httpStatusObj = spanAttributes.get("http.status_code");
            }
            if (httpStatusObj != null && (httpStatusCode = OTelSpanDerivationUtil.parseHttpStatusCode(httpStatusObj)) != null) {
                if (httpStatusCode >= 500) {
                    return new ErrorFaultResult(0, 1);
                }
                if (httpStatusCode >= 400) {
                    return new ErrorFaultResult(1, 0);
                }
                return new ErrorFaultResult(0, 0);
            }
        }
        if (OTelSpanDerivationUtil.isSpanStatusError(spanStatus)) {
            return new ErrorFaultResult(0, 1);
        }
        return new ErrorFaultResult(0, 0);
    }

    static Integer parseHttpStatusCode(Object statusCodeObject) {
        if (statusCodeObject == null) {
            return null;
        }
        try {
            if (statusCodeObject instanceof Integer) {
                return (Integer)statusCodeObject;
            }
            if (statusCodeObject instanceof Long) {
                return ((Long)statusCodeObject).intValue();
            }
            return Integer.parseInt(statusCodeObject.toString());
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean isSpanStatusError(Object spanStatus) {
        String statusString;
        if (spanStatus == null) {
            return false;
        }
        if (spanStatus instanceof Map) {
            Map statusMap = (Map)spanStatus;
            Object code = statusMap.get("code");
            if (code == null) {
                return false;
            }
            statusString = code.toString();
        } else {
            statusString = spanStatus.toString();
        }
        return "ERROR".equalsIgnoreCase(statusString) || "2".equals(statusString) || statusString.toLowerCase().contains("error");
    }

    private static String extractFirstPathFromUrl(String url) {
        int colonDoubleSlash = url.indexOf("://");
        int firstSlash = url.indexOf("/", colonDoubleSlash + 3);
        int secondSlash = url.indexOf("/", firstSlash + 1);
        String result = secondSlash > 0 ? url.substring(firstSlash, secondSlash) : url.substring(firstSlash);
        return result;
    }

    public static String computeOperationName(String spanName, Map<String, Object> spanAttributes) {
        String path;
        String method = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.request.method");
        if (method == null) {
            method = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.method");
        }
        if ((path = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.path")) == null) {
            path = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.target");
        }
        if (path == null) {
            path = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.url");
        }
        if (path == null) {
            path = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "url.full");
        }
        if (method != null && path != null && !path.isEmpty() && (spanName == null || "UnknownOperation".equals(spanName) || spanName.equals(method))) {
            int secondSlash;
            Object cleanPath = path.split("[?#]")[0];
            if (!((String)cleanPath).startsWith("/")) {
                cleanPath = "/" + (String)cleanPath;
            }
            Object firstPath = (secondSlash = ((String)cleanPath).indexOf(47, 1)) > 0 ? ((String)cleanPath).substring(0, secondSlash) : cleanPath;
            return method + " " + (String)firstPath;
        }
        if (method != null && spanName != null && spanName.equals(method)) {
            return "UnknownOperation";
        }
        return spanName != null ? spanName : "UnknownOperation";
    }

    public static RemoteOperationAndService computeRemoteOperationAndService(Map<String, Object> spanAttributes) {
        OTelSpanDerivationUtil oTelSpanDerivationUtil = new OTelSpanDerivationUtil();
        Map<String, String> awsServiceMappings = new AwsServiceMappingsProvider().getServiceMappings();
        RemoteOperationAndServiceProviders remoteOperationAndServiceProviders = new RemoteOperationAndServiceProviders();
        ServiceAddressPortAttributesProvider serviceAddressPortAttributesProvider = new ServiceAddressPortAttributesProvider();
        List<ServiceAddressPortAttributesProvider.AddressPortAttributeKeys> addressPortAttributeKeysList = serviceAddressPortAttributesProvider.getAddressPortAttributeKeysList();
        RemoteOperationAndService remoteOperationAndService = new RemoteOperationAndService(null, null);
        if (remoteOperationAndServiceProviders.AwsRpcRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.AwsRpcRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, awsServiceMappings);
        }
        if (remoteOperationAndServiceProviders.DbRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.DbRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (remoteOperationAndServiceProviders.DbQueryRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.DbQueryRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (remoteOperationAndServiceProviders.FaasRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.FaasRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (remoteOperationAndServiceProviders.MessagingSystemRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.MessagingSystemRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (remoteOperationAndServiceProviders.GraphQlRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.GraphQlRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (remoteOperationAndServiceProviders.AwsRpcRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.AwsRpcRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, awsServiceMappings);
        }
        if (remoteOperationAndServiceProviders.PeerServiceRemoteOperationServiceExtractor.appliesToSpan(spanAttributes)) {
            remoteOperationAndService = remoteOperationAndServiceProviders.PeerServiceRemoteOperationServiceExtractor.getRemoteOperationAndService(spanAttributes, null);
        }
        if (!remoteOperationAndService.hasNullValues()) {
            return remoteOperationAndService;
        }
        String urlString = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "url.full") != null ? OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "url.full") : OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.url");
        String remoteOperation = remoteOperationAndService.getOperation();
        String remoteService = remoteOperationAndService.getService();
        if (remoteService == null) {
            remoteService = OTelSpanDerivationUtil.deriveServiceFromNetwork(spanAttributes, urlString, addressPortAttributeKeysList);
        }
        if (remoteOperation == null && urlString != null) {
            String httpMethod = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.request.method") != null ? OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.request.method") : OTelSpanDerivationUtil.getStringAttribute(spanAttributes, "http.method");
            remoteOperation = httpMethod != null ? httpMethod + " " + OTelSpanDerivationUtil.extractFirstPathFromUrl(urlString) : urlString;
        }
        return new RemoteOperationAndService(remoteOperation != null ? remoteOperation : "UnknownRemoteOperation", remoteService != null ? remoteService : "UnknownRemoteService");
    }

    private static String deriveServiceFromNetwork(Map<String, Object> spanAttributes, String urlString, List<ServiceAddressPortAttributesProvider.AddressPortAttributeKeys> addressPortAttributeKeysList) {
        for (ServiceAddressPortAttributesProvider.AddressPortAttributeKeys addressPortAttributeKeys : addressPortAttributeKeysList) {
            String address = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, addressPortAttributeKeys.getAddress());
            if (address == null) continue;
            String port = OTelSpanDerivationUtil.getStringAttribute(spanAttributes, addressPortAttributeKeys.getPort());
            return port != null ? address + ":" + port : address;
        }
        if (urlString != null) {
            try {
                URL url = new URL(urlString);
                int port = url.getPort() == -1 ? url.getDefaultPort() : url.getPort();
                return url.getHost() + ":" + port;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static String computeEnvironment(Map<String, Object> spanAttributes) {
        String env = ServiceEnvironmentProviders.getAwsServiceEnvironment(spanAttributes);
        if (env == null) {
            env = ServiceEnvironmentProviders.getDeploymentEnvironment(spanAttributes);
        }
        return env;
    }

    static String getStringAttribute(Map<String, Object> map, String key) {
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        return value != null ? value.toString() : null;
    }

    @Deprecated
    static String getStringAttributeFromMap(Map<String, Object> map, String key) {
        return OTelSpanDerivationUtil.getStringAttribute(map, key);
    }

    public static class ErrorFaultResult {
        final int error;
        final int fault;

        public ErrorFaultResult(int error, int fault) {
            this.error = error;
            this.fault = fault;
        }

        public int getError() {
            return this.error;
        }

        public int getFault() {
            return this.fault;
        }
    }
}

