/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.processor.obfuscation.action;

import java.util.List;
import java.util.regex.Pattern;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.MaskActionConfig;
import org.opensearch.dataprepper.plugins.processor.obfuscation.action.ObfuscationAction;

@DataPrepperPlugin(name="mask", pluginType=ObfuscationAction.class, pluginConfigurationType=MaskActionConfig.class)
public class MaskAction
implements ObfuscationAction {
    private final String baseReplacement;

    @DataPrepperPluginConstructor
    public MaskAction(MaskActionConfig config) {
        this.baseReplacement = config.getMaskCharacter().repeat(config.getMaskCharacterLength());
    }

    @Override
    public String obfuscate(String source, List<Pattern> patterns, Record<Event> record) {
        if (patterns == null || patterns.size() == 0) {
            return this.baseReplacement;
        }
        for (Pattern pattern : patterns) {
            source = source.replaceAll(pattern.pattern(), this.baseReplacement);
        }
        return source;
    }
}

