/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.processor;

import com.fasterxml.jackson.annotation.JsonClassDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import java.util.Collections;
import java.util.List;
import org.opensearch.dataprepper.model.annotations.AlsoRequired;
import org.opensearch.dataprepper.model.annotations.ExampleValues;
import org.opensearch.dataprepper.plugins.lambda.common.config.InvocationType;
import org.opensearch.dataprepper.plugins.lambda.common.config.LambdaCommonConfig;
import org.opensearch.dataprepper.plugins.lambda.processor.LambdaResponseMode;

@JsonPropertyOrder
@JsonClassDescription(value="The <code>aws_lambda</code> processor enables invocation of an AWS Lambda function within your pipeline in order to process events. It supports both synchronous and asynchronous invocations based on your use case.")
public class LambdaProcessorConfig
extends LambdaCommonConfig {
    static final String DEFAULT_INVOCATION_TYPE = "request-response";
    protected static final int DEFAULT_CIRCUIT_BREAKER_RETRIES = 0;
    protected static final long DEFAULT_CIRCUIT_BREAKER_WAIT_INTERVAL_MS = 1000L;
    @JsonProperty(value="circuit_breaker_retries")
    @JsonPropertyDescription(value="Maximum number of times to check if circuit breaker is closed before proceeding. With default wait interval of 100ms, 150 retries equals 15 seconds of waiting.")
    private int circuitBreakerRetries = 0;
    @JsonProperty(value="circuit_breaker_wait_interval")
    @JsonPropertyDescription(value="Time in milliseconds to wait between circuit breaker checks. Defaults to 1000ms.")
    private long circuitBreakerWaitInterval = 1000L;
    @JsonPropertyDescription(value="Specifies the invocation type, either <code>request-response</code> or <code>event</code>. Default is <code>request-response</code>.")
    @JsonProperty(value="invocation_type", defaultValue="request-response")
    private InvocationType invocationType = InvocationType.REQUEST_RESPONSE;
    @JsonPropertyDescription(value="Specifies how Data Prepper interprets and processes Lambda function responses. Default is <code>false</code>.")
    @JsonProperty(value="response_events_match")
    private boolean responseEventsMatch = false;
    @JsonProperty(value="tags_on_failure")
    @JsonPropertyDescription(value="A <code>List</code> of <code>String</code>s that specifies the tags to be set in the event when lambda fails to or exception occurs. This tag may be used in conditional expressions in other parts of the configuration.")
    private List<String> tagsOnFailure = Collections.emptyList();
    @JsonPropertyDescription(value="Defines a condition for event to use this processor.")
    @ExampleValues(value={@ExampleValues.Example(value="/some_key == null", description="The processor will only run on events where this condition evaluates to true.")})
    @JsonProperty(value="lambda_when")
    private String whenCondition;
    @JsonProperty(value="response_mode")
    private LambdaResponseMode responseMode = LambdaResponseMode.REPLACE;
    @JsonProperty(value="cache")
    @AlsoRequired(values={@AlsoRequired.Required(name="response_mode", allowedValues={"merge"}), @AlsoRequired.Required(name="keys")})
    private CacheConfig cacheConfig;

    @AssertTrue(message="keys must not be null or empty and response_mode must be 'merge' when using cache")
    @AssertTrue(message="keys must not be null or empty and response_mode must be 'merge' when using cache") boolean isValidCacheConfig() {
        return this.cacheConfig == null || this.hasKeys() && this.responseMode == LambdaResponseMode.MERGE && this.getInvocationType() == InvocationType.REQUEST_RESPONSE;
    }

    public List<String> getTagsOnFailure() {
        return this.tagsOnFailure;
    }

    public String getWhenCondition() {
        return this.whenCondition;
    }

    public Boolean getResponseEventsMatch() {
        return this.responseEventsMatch;
    }

    public int getCircuitBreakerRetries() {
        return this.circuitBreakerRetries;
    }

    public long getCircuitBreakerWaitInterval() {
        return this.circuitBreakerWaitInterval;
    }

    public CacheConfig getCacheConfig() {
        return this.cacheConfig;
    }

    public LambdaResponseMode getResponseMode() {
        return this.responseMode;
    }

    @Override
    public InvocationType getInvocationType() {
        return this.invocationType;
    }

    public class CacheConfig {
        @JsonProperty(value="ttl")
        private long ttl;
        @JsonProperty(value="max_size")
        @Max(value=0xA00000L)
        @Min(value=0x100000L)
        private @Max(value=0xA00000L) @Min(value=0x100000L) long maxSize;

        public long getTtl() {
            return this.ttl;
        }

        public long getMaxSize() {
            return this.maxSize;
        }
    }
}

