/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.client;

import org.opensearch.dataprepper.aws.api.AwsCredentialsOptions;
import org.opensearch.dataprepper.aws.api.AwsCredentialsSupplier;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.plugins.lambda.common.config.AwsAuthenticationOptions;
import org.opensearch.dataprepper.plugins.lambda.common.config.ClientOptions;
import org.opensearch.dataprepper.plugins.lambda.common.util.CustomLambdaRetryCondition;
import org.opensearch.dataprepper.plugins.metricpublisher.MicrometerMetricPublisher;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.http.nio.netty.NettyNioAsyncHttpClient;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.services.lambda.LambdaAsyncClient;
import software.amazon.awssdk.services.lambda.LambdaAsyncClientBuilder;

public final class LambdaClientFactory {
    public static LambdaAsyncClient createAsyncLambdaClient(AwsAuthenticationOptions awsAuthenticationOptions, AwsCredentialsSupplier awsCredentialsSupplier, ClientOptions clientOptions) {
        AwsCredentialsOptions awsCredentialsOptions = LambdaClientFactory.convertToCredentialsOptions(awsAuthenticationOptions);
        AwsCredentialsProvider awsCredentialsProvider = awsCredentialsSupplier.getProvider(awsCredentialsOptions);
        PluginMetrics awsSdkMetrics = PluginMetrics.fromNames((String)"sdk", (String)"aws");
        NettyNioAsyncHttpClient.Builder httpClientBuilder = NettyNioAsyncHttpClient.builder().maxConcurrency(Integer.valueOf(clientOptions.getMaxConcurrency())).connectionTimeout(clientOptions.getConnectionTimeout());
        if (clientOptions.getReadTimeout() != null) {
            httpClientBuilder.readTimeout(clientOptions.getReadTimeout());
        }
        return (LambdaAsyncClient)((LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)((LambdaAsyncClientBuilder)LambdaAsyncClient.builder().region(awsAuthenticationOptions.getAwsRegion())).credentialsProvider(awsCredentialsProvider)).overrideConfiguration(LambdaClientFactory.createOverrideConfiguration(clientOptions, awsSdkMetrics))).httpClient(httpClientBuilder.build())).build();
    }

    private static ClientOverrideConfiguration createOverrideConfiguration(ClientOptions clientOptions, PluginMetrics awsSdkMetrics) {
        EqualJitterBackoffStrategy backoffStrategy = EqualJitterBackoffStrategy.builder().baseDelay(clientOptions.getBaseDelay()).maxBackoffTime(clientOptions.getMaxBackoff()).build();
        RetryPolicy customRetryPolicy = RetryPolicy.builder().retryCondition((RetryCondition)new CustomLambdaRetryCondition()).numRetries(Integer.valueOf(clientOptions.getMaxConnectionRetries())).backoffStrategy((BackoffStrategy)backoffStrategy).build();
        ClientOverrideConfiguration.Builder configBuilder = ClientOverrideConfiguration.builder().retryPolicy(customRetryPolicy).addMetricPublisher((MetricPublisher)new MicrometerMetricPublisher(awsSdkMetrics)).apiCallTimeout(clientOptions.getApiCallTimeout());
        if (clientOptions.getApiCallAttemptTimeout() != null) {
            configBuilder.apiCallAttemptTimeout(clientOptions.getApiCallAttemptTimeout());
        }
        return (ClientOverrideConfiguration)configBuilder.build();
    }

    public static AwsCredentialsOptions convertToCredentialsOptions(AwsAuthenticationOptions awsAuthenticationOptions) {
        return AwsCredentialsOptions.builder().withRegion(awsAuthenticationOptions.getAwsRegion()).withStsRoleArn(awsAuthenticationOptions.getAwsStsRoleArn()).withStsExternalId(awsAuthenticationOptions.getAwsStsExternalId()).withStsHeaderOverrides(awsAuthenticationOptions.getAwsStsHeaderOverrides()).build();
    }
}

