/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.lambda.common.accumlator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.StopWatch;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.JacksonEvent;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.plugins.codec.json.JsonOutputCodec;
import org.opensearch.dataprepper.plugins.codec.json.JsonOutputCodecConfig;
import org.opensearch.dataprepper.plugins.lambda.common.accumlator.Buffer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.lambda.model.InvokeRequest;

public class InMemoryBuffer
implements Buffer {
    private final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32768);
    protected List<Record<Event>> records;
    private final StopWatch bufferWatch;
    private final StopWatch lambdaLatencyWatch;
    private final OutputCodec requestCodec;
    private final OutputCodecContext outputCodecContext;
    private final long payloadResponseSize;
    private int eventCount;
    private long payloadRequestSize;
    private List<String> keys;
    private boolean codecStarted;
    private boolean codecCompleted;

    public InMemoryBuffer(String batchOptionKeyName) {
        this(batchOptionKeyName, new OutputCodecContext(), null);
    }

    public InMemoryBuffer(String batchOptionKeyName, OutputCodecContext outputCodecContext, List<String> keys) {
        this.keys = keys;
        this.records = new ArrayList<Record<Event>>();
        this.bufferWatch = new StopWatch();
        this.bufferWatch.start();
        this.lambdaLatencyWatch = new StopWatch();
        this.eventCount = 0;
        this.payloadRequestSize = 0L;
        this.payloadResponseSize = 0L;
        this.codecStarted = false;
        this.codecCompleted = false;
        JsonOutputCodecConfig jsonOutputCodecConfig = new JsonOutputCodecConfig();
        jsonOutputCodecConfig.setKeyName(batchOptionKeyName);
        this.requestCodec = new JsonOutputCodec(jsonOutputCodecConfig);
        this.outputCodecContext = outputCodecContext;
    }

    @Override
    public void addRecord(Record<Event> record) {
        this.records.add(record);
        Event event = (Event)record.getData();
        if (this.keys != null && this.keys.size() > 0) {
            JacksonEvent newEvent = JacksonEvent.builder().withEventType(event.getMetadata().getEventType()).build();
            for (String key : this.keys) {
                newEvent.put(key, event.get(key, Object.class));
            }
            event = newEvent;
        }
        try {
            if (this.eventCount == 0) {
                this.requestCodec.start((OutputStream)this.byteArrayOutputStream, event, this.outputCodecContext);
                this.codecStarted = true;
            }
            this.requestCodec.writeEvent(event, (OutputStream)this.byteArrayOutputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ++this.eventCount;
    }

    @Override
    public List<Record<Event>> getRecords() {
        return this.records;
    }

    @Override
    public long getSize() {
        return this.byteArrayOutputStream.size();
    }

    @Override
    public int getEventCount() {
        return this.eventCount;
    }

    @Override
    public Duration getDuration() {
        return Duration.ofMillis(this.bufferWatch.getTime(TimeUnit.MILLISECONDS));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvokeRequest getRequestPayload(String functionName, String invocationType) {
        if (this.eventCount == 0) {
            return null;
        }
        try {
            if (this.codecStarted && !this.codecCompleted) {
                this.requestCodec.complete((OutputStream)this.byteArrayOutputStream);
                this.codecCompleted = true;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        SdkBytes payload = this.getPayload();
        this.payloadRequestSize = payload.asByteArrayUnsafe().length;
        InvokeRequest request = (InvokeRequest)InvokeRequest.builder().functionName(functionName).payload(payload).invocationType(invocationType).build();
        InMemoryBuffer inMemoryBuffer = this;
        synchronized (inMemoryBuffer) {
            if (this.lambdaLatencyWatch.isStarted()) {
                this.lambdaLatencyWatch.reset();
            }
            this.lambdaLatencyWatch.start();
        }
        return request;
    }

    @Override
    public synchronized Duration stopLatencyWatch() {
        if (this.lambdaLatencyWatch.isStarted()) {
            this.lambdaLatencyWatch.stop();
        }
        long timeInMillis = this.lambdaLatencyWatch.getTime();
        return Duration.ofMillis(timeInMillis);
    }

    private SdkBytes getPayload() {
        return SdkBytes.fromByteArrayUnsafe((byte[])this.byteArrayOutputStream.toByteArray());
    }

    @Override
    public Duration getFlushLambdaLatencyMetric() {
        return Duration.ofMillis(this.lambdaLatencyWatch.getTime(TimeUnit.MILLISECONDS));
    }

    @Override
    public Long getPayloadRequestSize() {
        return this.payloadRequestSize;
    }
}

