/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DiversifiedTopDocsCollector;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.util.BytesRef;
import org.opensearch.OpenSearchException;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.BytesRefHash;
import org.opensearch.index.fielddata.AbstractNumericDocValues;
import org.opensearch.index.fielddata.SortedBinaryDocValues;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.sampler.BestDocsDeferringCollector;
import org.opensearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

public class DiversifiedMapSamplerAggregator
extends SamplerAggregator {
    private ValuesSource valuesSource;
    private int maxDocsPerValue;
    private BytesRefHash bucketOrds;

    DiversifiedMapSamplerAggregator(String name, int shardSize, AggregatorFactories factories, SearchContext context, Aggregator parent, Map<String, Object> metadata, ValuesSourceConfig valuesSourceConfig, int maxDocsPerValue) throws IOException {
        super(name, shardSize, factories, context, parent, metadata);
        assert (valuesSourceConfig.hasValues());
        this.valuesSource = valuesSourceConfig.getValuesSource();
        this.maxDocsPerValue = maxDocsPerValue;
        this.bucketOrds = new BytesRefHash(this.shardSize, context.bigArrays());
    }

    @Override
    protected void doClose() {
        Releasables.close((Releasable)this.bucketOrds);
        super.doClose();
    }

    @Override
    public DeferringBucketCollector getDeferringCollector() {
        this.bdd = new DiverseDocsDeferringCollector(this::addRequestCircuitBreakerBytes);
        return this.bdd;
    }

    class DiverseDocsDeferringCollector
    extends BestDocsDeferringCollector {
        DiverseDocsDeferringCollector(Consumer<Long> circuitBreakerConsumer) {
            super(DiversifiedMapSamplerAggregator.this.shardSize, DiversifiedMapSamplerAggregator.this.context.bigArrays(), circuitBreakerConsumer);
        }

        protected TopDocsCollector<DiversifiedTopDocsCollector.ScoreDocKey> createTopDocsCollector(int size) {
            int minMaxDocsPerValue = Math.min(DiversifiedMapSamplerAggregator.this.maxDocsPerValue, DiversifiedMapSamplerAggregator.this.context.searcher().getIndexReader().maxDoc());
            return new ValuesDiversifiedTopDocsCollector(size, minMaxDocsPerValue);
        }

        @Override
        protected long getPriorityQueueSlotSize() {
            return SamplerAggregator.SCOREDOCKEY_SIZE;
        }

        class ValuesDiversifiedTopDocsCollector
        extends DiversifiedTopDocsCollector {
            private SortedBinaryDocValues values;

            ValuesDiversifiedTopDocsCollector(int numHits, int maxHitsPerKey) {
                super(numHits, maxHitsPerKey);
            }

            protected NumericDocValues getKeys(LeafReaderContext context) {
                try {
                    this.values = DiversifiedMapSamplerAggregator.this.valuesSource.bytesValues(context);
                }
                catch (IOException e) {
                    throw new OpenSearchException("Error reading values", (Throwable)e, new Object[0]);
                }
                return new AbstractNumericDocValues(){
                    private int docID = -1;

                    public boolean advanceExact(int target) throws IOException {
                        this.docID = target;
                        if (ValuesDiversifiedTopDocsCollector.this.values.advanceExact(target)) {
                            if (ValuesDiversifiedTopDocsCollector.this.values.docValueCount() > 1) {
                                throw new IllegalArgumentException("Sample diversifying key must be a single valued-field");
                            }
                            return true;
                        }
                        return false;
                    }

                    public int docID() {
                        return this.docID;
                    }

                    public long longValue() throws IOException {
                        BytesRef bytes = ValuesDiversifiedTopDocsCollector.this.values.nextValue();
                        long bucketOrdinal = DiversifiedMapSamplerAggregator.this.bucketOrds.add(bytes);
                        if (bucketOrdinal < 0L) {
                            bucketOrdinal = -1L - bucketOrdinal;
                        }
                        return bucketOrdinal;
                    }
                };
            }
        }
    }
}

