/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.recovery;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.RateLimiter;
import org.opensearch.ExceptionsHelper;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchTimeoutException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRunnable;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ClusterStateObserver;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.CheckedFunction;
import org.opensearch.common.Nullable;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.ByteSizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.CancellableThreads;
import org.opensearch.common.util.concurrent.AbstractRunnable;
import org.opensearch.index.engine.RecoveryEngineException;
import org.opensearch.index.mapper.MapperException;
import org.opensearch.index.shard.IllegalIndexShardStateException;
import org.opensearch.index.shard.IndexEventListener;
import org.opensearch.index.shard.IndexShard;
import org.opensearch.index.shard.ShardId;
import org.opensearch.index.shard.ShardNotFoundException;
import org.opensearch.index.store.Store;
import org.opensearch.index.translog.Translog;
import org.opensearch.index.translog.TranslogCorruptedException;
import org.opensearch.indices.recovery.DelayRecoveryException;
import org.opensearch.indices.recovery.PeerRecoveryNotFound;
import org.opensearch.indices.recovery.RecoveriesCollection;
import org.opensearch.indices.recovery.RecoveryCleanFilesRequest;
import org.opensearch.indices.recovery.RecoveryFailedException;
import org.opensearch.indices.recovery.RecoveryFileChunkRequest;
import org.opensearch.indices.recovery.RecoveryFilesInfoRequest;
import org.opensearch.indices.recovery.RecoveryFinalizeRecoveryRequest;
import org.opensearch.indices.recovery.RecoveryHandoffPrimaryContextRequest;
import org.opensearch.indices.recovery.RecoveryPrepareForTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryResponse;
import org.opensearch.indices.recovery.RecoverySettings;
import org.opensearch.indices.recovery.RecoveryState;
import org.opensearch.indices.recovery.RecoveryTarget;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsRequest;
import org.opensearch.indices.recovery.RecoveryTranslogOperationsResponse;
import org.opensearch.indices.recovery.RecoveryTransportRequest;
import org.opensearch.indices.recovery.ReestablishRecoveryRequest;
import org.opensearch.indices.recovery.StartRecoveryRequest;
import org.opensearch.tasks.Task;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.ConnectTransportException;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportException;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportResponse;
import org.opensearch.transport.TransportResponseHandler;
import org.opensearch.transport.TransportService;

public class PeerRecoveryTargetService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(PeerRecoveryTargetService.class);
    private final ThreadPool threadPool;
    private final TransportService transportService;
    private final RecoverySettings recoverySettings;
    private final ClusterService clusterService;
    private final RecoveriesCollection onGoingRecoveries;

    public PeerRecoveryTargetService(ThreadPool threadPool, TransportService transportService, RecoverySettings recoverySettings, ClusterService clusterService) {
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.recoverySettings = recoverySettings;
        this.clusterService = clusterService;
        this.onGoingRecoveries = new RecoveriesCollection(logger, threadPool);
        transportService.registerRequestHandler("internal:index/shard/recovery/filesInfo", "generic", RecoveryFilesInfoRequest::new, new FilesInfoRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/file_chunk", "generic", RecoveryFileChunkRequest::new, new FileChunkTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/clean_files", "generic", RecoveryCleanFilesRequest::new, new CleanFilesRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/prepare_translog", "generic", RecoveryPrepareForTranslogOperationsRequest::new, new PrepareForTranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/translog_ops", "generic", RecoveryTranslogOperationsRequest::new, new TranslogOperationsRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/finalize", "generic", RecoveryFinalizeRecoveryRequest::new, new FinalizeRecoveryRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/handoff_primary_context", "generic", RecoveryHandoffPrimaryContextRequest::new, new HandoffPrimaryContextRequestHandler());
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.onGoingRecoveries.cancelRecoveriesForShard(shardId, "shard closed");
        }
    }

    public void startRecovery(IndexShard indexShard, DiscoveryNode sourceNode, RecoveryListener listener) {
        long recoveryId = this.onGoingRecoveries.startRecovery(indexShard, sourceNode, listener, this.recoverySettings.activityTimeout());
        this.threadPool.generic().execute(new RecoveryRunner(recoveryId));
    }

    protected void retryRecovery(long recoveryId, Throwable reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace(() -> new ParameterizedMessage("will retry recovery with id [{}] in [{}]", (Object)recoveryId, (Object)retryAfter), reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    protected void retryRecovery(long recoveryId, String reason, TimeValue retryAfter, TimeValue activityTimeout) {
        logger.trace("will retry recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.retryRecovery(recoveryId, retryAfter, activityTimeout);
    }

    private void retryRecovery(long recoveryId, TimeValue retryAfter, TimeValue activityTimeout) {
        RecoveryTarget newTarget = this.onGoingRecoveries.resetRecovery(recoveryId, activityTimeout);
        if (newTarget != null) {
            this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", new RecoveryRunner(newTarget.recoveryId()));
        }
    }

    protected void reestablishRecovery(StartRecoveryRequest request, String reason, TimeValue retryAfter) {
        long recoveryId = request.recoveryId();
        logger.trace("will try to reestablish recovery with id [{}] in [{}] (reason [{}])", (Object)recoveryId, (Object)retryAfter, (Object)reason);
        this.threadPool.scheduleUnlessShuttingDown(retryAfter, "generic", new RecoveryRunner(recoveryId, request));
    }

    private void doRecovery(long recoveryId, StartRecoveryRequest preExistingRequest) {
        String actionName;
        TransportRequest requestToSend;
        StartRecoveryRequest startRequest;
        CancellableThreads cancellableThreads;
        RecoveryState.Timer timer;
        block18: {
            try (RecoveriesCollection.RecoveryRef recoveryRef = this.onGoingRecoveries.getRecovery(recoveryId);){
                if (recoveryRef == null) {
                    logger.trace("not running recovery with id [{}] - can not find it (probably finished)", (Object)recoveryId);
                    return;
                }
                RecoveryTarget recoveryTarget = recoveryRef.target();
                timer = recoveryTarget.state().getTimer();
                cancellableThreads = recoveryTarget.cancellableThreads();
                if (preExistingRequest == null) {
                    try {
                        IndexShard indexShard = recoveryTarget.indexShard();
                        indexShard.preRecovery();
                        assert (recoveryTarget.sourceNode() != null) : "can not do a recovery without a source node";
                        logger.trace("{} preparing shard for peer recovery", (Object)recoveryTarget.shardId());
                        indexShard.prepareForIndexRecovery();
                        long startingSeqNo = indexShard.recoverLocallyUpToGlobalCheckpoint();
                        assert (startingSeqNo == -2L || recoveryTarget.state().getStage() == RecoveryState.Stage.TRANSLOG) : "unexpected recovery stage [" + (Object)((Object)recoveryTarget.state().getStage()) + "] starting seqno [ " + startingSeqNo + "]";
                        startRequest = PeerRecoveryTargetService.getStartRecoveryRequest(logger, this.clusterService.localNode(), recoveryTarget, startingSeqNo);
                        requestToSend = startRequest;
                        actionName = "internal:index/shard/recovery/start_recovery";
                    }
                    catch (Exception e) {
                        logger.trace("unexpected error while preparing shard for peer recovery, failing recovery", (Throwable)e);
                        this.onGoingRecoveries.failRecovery(recoveryId, new RecoveryFailedException(recoveryTarget.state(), "failed to prepare shard for recovery", (Throwable)e), true);
                        if (recoveryRef != null) {
                            recoveryRef.close();
                        }
                        return;
                    }
                    logger.trace("{} starting recovery from {}", (Object)startRequest.shardId(), (Object)startRequest.sourceNode());
                    break block18;
                }
                startRequest = preExistingRequest;
                requestToSend = new ReestablishRecoveryRequest(recoveryId, startRequest.shardId(), startRequest.targetAllocationId());
                actionName = "internal:index/shard/recovery/reestablish_recovery";
                logger.trace("{} reestablishing recovery from {}", (Object)startRequest.shardId(), (Object)startRequest.sourceNode());
            }
        }
        RecoveryResponseHandler responseHandler = new RecoveryResponseHandler(startRequest, timer);
        try {
            cancellableThreads.executeIO(() -> this.transportService.sendRequest(startRequest.sourceNode(), actionName, requestToSend, responseHandler));
        }
        catch (CancellableThreads.ExecutionCancelledException e) {
            logger.trace("recovery cancelled", (Throwable)e);
        }
        catch (Exception e) {
            responseHandler.onException(e);
        }
    }

    public static StartRecoveryRequest getStartRecoveryRequest(Logger logger, DiscoveryNode localNode, RecoveryTarget recoveryTarget, long startingSeqNo) {
        Store.MetadataSnapshot metadataSnapshot;
        logger.trace("{} collecting local files for [{}]", (Object)recoveryTarget.shardId(), (Object)recoveryTarget.sourceNode());
        try {
            metadataSnapshot = recoveryTarget.indexShard().snapshotStoreMetadata();
            try {
                String expectedTranslogUUID = metadataSnapshot.getCommitUserData().get("translog_uuid");
                long globalCheckpoint = Translog.readGlobalCheckpoint(recoveryTarget.translogLocation(), expectedTranslogUUID);
                assert (globalCheckpoint + 1L >= startingSeqNo) : "invalid startingSeqNo " + startingSeqNo + " >= " + globalCheckpoint;
            }
            catch (IOException | TranslogCorruptedException e) {
                logger.warn((Message)new ParameterizedMessage("error while reading global checkpoint from translog, resetting the starting sequence number from {} to unassigned and recovering as if there are none", (Object)startingSeqNo), (Throwable)e);
                metadataSnapshot = Store.MetadataSnapshot.EMPTY;
                startingSeqNo = -2L;
            }
        }
        catch (IndexNotFoundException e) {
            assert (startingSeqNo == -2L) : startingSeqNo;
            logger.trace("{} shard folder empty, recovering all files", (Object)recoveryTarget);
            metadataSnapshot = Store.MetadataSnapshot.EMPTY;
        }
        catch (IOException e) {
            if (startingSeqNo != -2L) {
                logger.warn((Message)new ParameterizedMessage("error while listing local files, resetting the starting sequence number from {} to unassigned and recovering as if there are none", (Object)startingSeqNo), (Throwable)e);
                startingSeqNo = -2L;
            } else {
                logger.warn("error while listing local files, recovering as if there are none", (Throwable)e);
            }
            metadataSnapshot = Store.MetadataSnapshot.EMPTY;
        }
        logger.trace("{} local file count [{}]", (Object)recoveryTarget.shardId(), (Object)metadataSnapshot.size());
        StartRecoveryRequest request = new StartRecoveryRequest(recoveryTarget.shardId(), recoveryTarget.indexShard().routingEntry().allocationId().getId(), recoveryTarget.sourceNode(), localNode, metadataSnapshot, recoveryTarget.state().getPrimary(), recoveryTarget.recoveryId(), startingSeqNo);
        return request;
    }

    private ActionListener<Void> createOrFinishListener(RecoveriesCollection.RecoveryRef recoveryRef, TransportChannel channel, String action, RecoveryTransportRequest request) {
        return this.createOrFinishListener(recoveryRef, channel, action, request, (CheckedFunction<Void, TransportResponse, Exception>)((CheckedFunction)nullVal -> TransportResponse.Empty.INSTANCE));
    }

    private ActionListener<Void> createOrFinishListener(RecoveriesCollection.RecoveryRef recoveryRef, TransportChannel channel, String action, RecoveryTransportRequest request, CheckedFunction<Void, TransportResponse, Exception> responseFn) {
        RecoveryTarget recoveryTarget = recoveryRef.target();
        ChannelActionListener channelListener = new ChannelActionListener(channel, action, request);
        ActionListener<Void> voidListener = ActionListener.map(channelListener, responseFn);
        long requestSeqNo = request.requestSeqNo();
        ActionListener<Void> listener = requestSeqNo != -2L ? recoveryTarget.markRequestReceivedAndCreateListener(requestSeqNo, voidListener) : voidListener;
        return listener;
    }

    private class RecoveryResponseHandler
    implements TransportResponseHandler<RecoveryResponse> {
        private final long recoveryId;
        private final StartRecoveryRequest request;
        private final RecoveryState.Timer timer;

        private RecoveryResponseHandler(StartRecoveryRequest request, RecoveryState.Timer timer) {
            this.recoveryId = request.recoveryId();
            this.request = request;
            this.timer = timer;
        }

        @Override
        public void handleResponse(RecoveryResponse recoveryResponse) {
            TimeValue recoveryTime = new TimeValue(this.timer.time());
            PeerRecoveryTargetService.this.onGoingRecoveries.markRecoveryAsDone(this.recoveryId);
            if (logger.isTraceEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append('[').append(this.request.shardId().getIndex().getName()).append(']').append('[').append(this.request.shardId().id()).append("] ");
                sb.append("recovery completed from ").append(this.request.sourceNode()).append(", took[").append(recoveryTime).append("]\n");
                sb.append("   phase1: recovered_files [").append(recoveryResponse.phase1FileNames.size()).append("]").append(" with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1TotalSize)).append("]").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1Time)).append("], throttling_wait [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase1ThrottlingWaitTime)).append(']').append("\n");
                sb.append("         : reusing_files   [").append(recoveryResponse.phase1ExistingFileNames.size()).append("] with total_size of [").append(new ByteSizeValue(recoveryResponse.phase1ExistingTotalSize)).append("]\n");
                sb.append("   phase2: start took [").append(TimeValue.timeValueMillis((long)recoveryResponse.startTime)).append("]\n");
                sb.append("         : recovered [").append(recoveryResponse.phase2Operations).append("]").append(" transaction log operations").append(", took [").append(TimeValue.timeValueMillis((long)recoveryResponse.phase2Time)).append("]").append("\n");
                logger.trace("{}", (Object)sb);
            } else {
                logger.debug("{} recovery done from [{}], took [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)recoveryTime);
            }
        }

        @Override
        public void handleException(TransportException e) {
            this.onException(e);
        }

        private void onException(Exception e) {
            Throwable cause;
            if (logger.isTraceEnabled()) {
                logger.trace(() -> new ParameterizedMessage("[{}][{}] Got exception on recovery", (Object)this.request.shardId().getIndex().getName(), (Object)this.request.shardId().id()), (Throwable)e);
            }
            if ((cause = ExceptionsHelper.unwrapCause(e)) instanceof CancellableThreads.ExecutionCancelledException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, "source has canceled the recovery", cause), false);
                return;
            }
            if (cause instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if ((cause = ExceptionsHelper.unwrapCause(cause)) instanceof RecoveryEngineException) {
                cause = cause.getCause();
            }
            if (cause instanceof IllegalIndexShardStateException || cause instanceof org.opensearch.index.IndexNotFoundException || cause instanceof ShardNotFoundException) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, "remote shard not ready", PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof DelayRecoveryException || cause instanceof PeerRecoveryNotFound) {
                PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, cause, PeerRecoveryTargetService.this.recoverySettings.retryDelayStateSync(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                return;
            }
            if (cause instanceof ConnectTransportException) {
                logger.info("recovery of {} from [{}] interrupted by network disconnect, will retry in [{}]; cause: [{}]", (Object)this.request.shardId(), (Object)this.request.sourceNode(), (Object)PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork(), (Object)cause.getMessage());
                if (this.request.sourceNode().getVersion().onOrAfter(LegacyESVersion.V_7_9_0)) {
                    PeerRecoveryTargetService.this.reestablishRecovery(this.request, cause.getMessage(), PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork());
                } else {
                    PeerRecoveryTargetService.this.retryRecovery(this.recoveryId, cause.getMessage(), PeerRecoveryTargetService.this.recoverySettings.retryDelayNetwork(), PeerRecoveryTargetService.this.recoverySettings.activityTimeout());
                }
                return;
            }
            if (cause instanceof AlreadyClosedException) {
                PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, "source shard is closed", cause), false);
                return;
            }
            PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(this.request, (Throwable)e), true);
        }

        @Override
        public String executor() {
            return "generic";
        }

        @Override
        public RecoveryResponse read(StreamInput in) throws IOException {
            return new RecoveryResponse(in);
        }
    }

    class RecoveryRunner
    extends AbstractRunnable {
        final long recoveryId;
        private final StartRecoveryRequest startRecoveryRequest;

        RecoveryRunner(long recoveryId) {
            this(recoveryId, null);
        }

        RecoveryRunner(long recoveryId, StartRecoveryRequest startRecoveryRequest) {
            this.recoveryId = recoveryId;
            this.startRecoveryRequest = startRecoveryRequest;
        }

        @Override
        public void onFailure(Exception e) {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecovery(this.recoveryId);){
                if (recoveryRef != null) {
                    logger.error(() -> new ParameterizedMessage("unexpected error during recovery [{}], failing shard", (Object)this.recoveryId), (Throwable)e);
                    PeerRecoveryTargetService.this.onGoingRecoveries.failRecovery(this.recoveryId, new RecoveryFailedException(recoveryRef.target().state(), "unexpected error", (Throwable)e), true);
                } else {
                    logger.debug(() -> new ParameterizedMessage("unexpected error during recovery, but recovery id [{}] is finished", (Object)this.recoveryId), (Throwable)e);
                }
            }
        }

        @Override
        public void doRun() {
            PeerRecoveryTargetService.this.doRecovery(this.recoveryId, this.startRecoveryRequest);
        }
    }

    class FileChunkTransportRequestHandler
    implements TransportRequestHandler<RecoveryFileChunkRequest> {
        final AtomicLong bytesSinceLastPause = new AtomicLong();

        FileChunkTransportRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFileChunkRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                long bytes;
                RateLimiter rateLimiter;
                RecoveryTarget recoveryTarget = recoveryRef.target();
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/file_chunk", request);
                if (listener == null) {
                    return;
                }
                RecoveryState.Index indexState = recoveryTarget.state().getIndex();
                if (request.sourceThrottleTimeInNanos() != -1L) {
                    indexState.addSourceThrottling(request.sourceThrottleTimeInNanos());
                }
                if ((rateLimiter = PeerRecoveryTargetService.this.recoverySettings.rateLimiter()) != null && (bytes = this.bytesSinceLastPause.addAndGet(request.content().length())) > rateLimiter.getMinPauseCheckBytes()) {
                    this.bytesSinceLastPause.addAndGet(-bytes);
                    long throttleTimeInNanos = rateLimiter.pause(bytes);
                    indexState.addTargetThrottling(throttleTimeInNanos);
                    recoveryTarget.indexShard().recoveryStats().addThrottleTime(throttleTimeInNanos);
                }
                recoveryTarget.writeFileChunk(request.metadata(), request.position(), request.content(), request.lastChunk(), request.totalTranslogOps(), listener);
            }
        }
    }

    class CleanFilesRequestHandler
    implements TransportRequestHandler<RecoveryCleanFilesRequest> {
        CleanFilesRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryCleanFilesRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/clean_files", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().cleanFiles(request.totalTranslogOps(), request.getGlobalCheckpoint(), request.sourceMetaSnapshot(), listener);
            }
        }
    }

    class FilesInfoRequestHandler
    implements TransportRequestHandler<RecoveryFilesInfoRequest> {
        FilesInfoRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFilesInfoRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/filesInfo", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().receiveFileInfo(request.phase1FileNames, request.phase1FileSizes, request.phase1ExistingFileNames, request.phase1ExistingFileSizes, request.totalTranslogOps, listener);
            }
        }
    }

    class TranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryTranslogOperationsRequest> {
        TranslogOperationsRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryTranslogOperationsRequest request, TransportChannel channel, Task task) throws IOException {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                RecoveryTarget recoveryTarget = recoveryRef.target();
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/translog_ops", request, (CheckedFunction<Void, TransportResponse, Exception>)nullVal -> new RecoveryTranslogOperationsResponse(recoveryTarget.indexShard().getLocalCheckpoint()));
                if (listener == null) {
                    return;
                }
                this.performTranslogOps(request, listener, recoveryRef);
            }
        }

        private void performTranslogOps(final RecoveryTranslogOperationsRequest request, final ActionListener<Void> listener, RecoveriesCollection.RecoveryRef recoveryRef) {
            RecoveryTarget recoveryTarget = recoveryRef.target();
            ClusterStateObserver observer = new ClusterStateObserver(PeerRecoveryTargetService.this.clusterService, null, logger, PeerRecoveryTargetService.this.threadPool.getThreadContext());
            Consumer<Exception> retryOnMappingException = exception -> {
                logger.debug("delaying recovery due to missing mapping changes", (Throwable)exception);
                observer.waitForNextChange(new ClusterStateObserver.Listener(){

                    @Override
                    public void onNewClusterState(ClusterState state) {
                        PeerRecoveryTargetService.this.threadPool.generic().execute(ActionRunnable.wrap(listener, l -> {
                            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                                TranslogOperationsRequestHandler.this.performTranslogOps(request, listener, recoveryRef);
                            }
                        }));
                    }

                    @Override
                    public void onClusterServiceClose() {
                        listener.onFailure(new OpenSearchException("cluster service was closed while waiting for mapping updates", new Object[0]));
                    }

                    @Override
                    public void onTimeout(TimeValue timeout) {
                        listener.onFailure(new OpenSearchTimeoutException("timed out waiting for mapping updates (timeout [" + timeout + "])", new Object[0]));
                    }
                });
            };
            IndexMetadata indexMetadata = PeerRecoveryTargetService.this.clusterService.state().metadata().index(request.shardId().getIndex());
            long mappingVersionOnTarget = indexMetadata != null ? indexMetadata.getMappingVersion() : 0L;
            recoveryTarget.indexTranslogOperations(request.operations(), request.totalTranslogOps(), request.maxSeenAutoIdTimestampOnPrimary(), request.maxSeqNoOfUpdatesOrDeletesOnPrimary(), request.retentionLeases(), request.mappingVersionOnPrimary(), ActionListener.wrap(checkpoint -> listener.onResponse(null), e -> {
                if (mappingVersionOnTarget < request.mappingVersionOnPrimary() && e instanceof MapperException) {
                    retryOnMappingException.accept((Exception)e);
                } else {
                    listener.onFailure((Exception)e);
                }
            }));
        }
    }

    class HandoffPrimaryContextRequestHandler
    implements TransportRequestHandler<RecoveryHandoffPrimaryContextRequest> {
        HandoffPrimaryContextRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryHandoffPrimaryContextRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                recoveryRef.target().handoffPrimaryContext(request.primaryContext());
            }
            channel.sendResponse(TransportResponse.Empty.INSTANCE);
        }
    }

    class FinalizeRecoveryRequestHandler
    implements TransportRequestHandler<RecoveryFinalizeRecoveryRequest> {
        FinalizeRecoveryRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryFinalizeRecoveryRequest request, TransportChannel channel, Task task) throws Exception {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/finalize", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().finalizeRecovery(request.globalCheckpoint(), request.trimAboveSeqNo(), listener);
            }
        }
    }

    class PrepareForTranslogOperationsRequestHandler
    implements TransportRequestHandler<RecoveryPrepareForTranslogOperationsRequest> {
        PrepareForTranslogOperationsRequestHandler() {
        }

        @Override
        public void messageReceived(RecoveryPrepareForTranslogOperationsRequest request, TransportChannel channel, Task task) {
            try (RecoveriesCollection.RecoveryRef recoveryRef = PeerRecoveryTargetService.this.onGoingRecoveries.getRecoverySafe(request.recoveryId(), request.shardId());){
                ActionListener listener = PeerRecoveryTargetService.this.createOrFinishListener(recoveryRef, channel, "internal:index/shard/recovery/prepare_translog", request);
                if (listener == null) {
                    return;
                }
                recoveryRef.target().prepareForTranslogOperations(request.totalTranslogOps(), listener);
            }
        }
    }

    public static interface RecoveryListener {
        public void onRecoveryDone(RecoveryState var1);

        public void onRecoveryFailure(RecoveryState var1, RecoveryFailedException var2, boolean var3);
    }

    public static class Actions {
        public static final String FILES_INFO = "internal:index/shard/recovery/filesInfo";
        public static final String FILE_CHUNK = "internal:index/shard/recovery/file_chunk";
        public static final String CLEAN_FILES = "internal:index/shard/recovery/clean_files";
        public static final String TRANSLOG_OPS = "internal:index/shard/recovery/translog_ops";
        public static final String PREPARE_TRANSLOG = "internal:index/shard/recovery/prepare_translog";
        public static final String FINALIZE = "internal:index/shard/recovery/finalize";
        public static final String HANDOFF_PRIMARY_CONTEXT = "internal:index/shard/recovery/handoff_primary_context";
    }
}

