/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.services.opensearchserverless.model.SamlConfigOptions;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateIamIdentityCenterConfigOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSecurityConfigRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, UpdateSecurityConfigRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::id)).setter(UpdateSecurityConfigRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configVersion").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::configVersion)).setter(UpdateSecurityConfigRequest.setter(Builder::configVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configVersion").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::description)).setter(UpdateSecurityConfigRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("samlOptions").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::samlOptions)).setter(UpdateSecurityConfigRequest.setter(Builder::samlOptions)).constructor(SamlConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()}).build();
    private static final SdkField<UpdateIamIdentityCenterConfigOptions> IAM_IDENTITY_CENTER_OPTIONS_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptionsUpdates").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::iamIdentityCenterOptionsUpdates)).setter(UpdateSecurityConfigRequest.setter(Builder::iamIdentityCenterOptionsUpdates)).constructor(UpdateIamIdentityCenterConfigOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptionsUpdates").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateSecurityConfigRequest.getter(UpdateSecurityConfigRequest::clientToken)).setter(UpdateSecurityConfigRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CONFIG_VERSION_FIELD, DESCRIPTION_FIELD, SAML_OPTIONS_FIELD, IAM_IDENTITY_CENTER_OPTIONS_UPDATES_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSecurityConfigRequest.memberNameToFieldInitializer();
    private final String id;
    private final String configVersion;
    private final String description;
    private final SamlConfigOptions samlOptions;
    private final UpdateIamIdentityCenterConfigOptions iamIdentityCenterOptionsUpdates;
    private final String clientToken;

    private UpdateSecurityConfigRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.configVersion = builder.configVersion;
        this.description = builder.description;
        this.samlOptions = builder.samlOptions;
        this.iamIdentityCenterOptionsUpdates = builder.iamIdentityCenterOptionsUpdates;
        this.clientToken = builder.clientToken;
    }

    public final String id() {
        return this.id;
    }

    public final String configVersion() {
        return this.configVersion;
    }

    public final String description() {
        return this.description;
    }

    public final SamlConfigOptions samlOptions() {
        return this.samlOptions;
    }

    public final UpdateIamIdentityCenterConfigOptions iamIdentityCenterOptionsUpdates() {
        return this.iamIdentityCenterOptionsUpdates;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.configVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamIdentityCenterOptionsUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityConfigRequest)) {
            return false;
        }
        UpdateSecurityConfigRequest other = (UpdateSecurityConfigRequest)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.configVersion(), other.configVersion()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.samlOptions(), other.samlOptions()) && Objects.equals(this.iamIdentityCenterOptionsUpdates(), other.iamIdentityCenterOptionsUpdates()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSecurityConfigRequest").add("Id", (Object)this.id()).add("ConfigVersion", (Object)this.configVersion()).add("Description", (Object)this.description()).add("SamlOptions", (Object)this.samlOptions()).add("IamIdentityCenterOptionsUpdates", (Object)this.iamIdentityCenterOptionsUpdates()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "configVersion": {
                return Optional.ofNullable(clazz.cast(this.configVersion()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "samlOptions": {
                return Optional.ofNullable(clazz.cast(this.samlOptions()));
            }
            case "iamIdentityCenterOptionsUpdates": {
                return Optional.ofNullable(clazz.cast(this.iamIdentityCenterOptionsUpdates()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("configVersion", CONFIG_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("samlOptions", SAML_OPTIONS_FIELD);
        map.put("iamIdentityCenterOptionsUpdates", IAM_IDENTITY_CENTER_OPTIONS_UPDATES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityConfigRequest, T> g) {
        return obj -> g.apply((UpdateSecurityConfigRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private String id;
        private String configVersion;
        private String description;
        private SamlConfigOptions samlOptions;
        private UpdateIamIdentityCenterConfigOptions iamIdentityCenterOptionsUpdates;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityConfigRequest model) {
            super(model);
            this.id(model.id);
            this.configVersion(model.configVersion);
            this.description(model.description);
            this.samlOptions(model.samlOptions);
            this.iamIdentityCenterOptionsUpdates(model.iamIdentityCenterOptionsUpdates);
            this.clientToken(model.clientToken);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getConfigVersion() {
            return this.configVersion;
        }

        public final void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        @Override
        public final Builder configVersion(String configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return this.samlOptions != null ? this.samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final UpdateIamIdentityCenterConfigOptions.Builder getIamIdentityCenterOptionsUpdates() {
            return this.iamIdentityCenterOptionsUpdates != null ? this.iamIdentityCenterOptionsUpdates.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptionsUpdates(UpdateIamIdentityCenterConfigOptions.BuilderImpl iamIdentityCenterOptionsUpdates) {
            this.iamIdentityCenterOptionsUpdates = iamIdentityCenterOptionsUpdates != null ? iamIdentityCenterOptionsUpdates.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptionsUpdates(UpdateIamIdentityCenterConfigOptions iamIdentityCenterOptionsUpdates) {
            this.iamIdentityCenterOptionsUpdates = iamIdentityCenterOptionsUpdates;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityConfigRequest build() {
            return new UpdateSecurityConfigRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSecurityConfigRequest> {
        public Builder id(String var1);

        public Builder configVersion(String var1);

        public Builder description(String var1);

        public Builder samlOptions(SamlConfigOptions var1);

        default public Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return this.samlOptions((SamlConfigOptions)((SamlConfigOptions.Builder)SamlConfigOptions.builder().applyMutation(samlOptions)).build());
        }

        public Builder iamIdentityCenterOptionsUpdates(UpdateIamIdentityCenterConfigOptions var1);

        default public Builder iamIdentityCenterOptionsUpdates(Consumer<UpdateIamIdentityCenterConfigOptions.Builder> iamIdentityCenterOptionsUpdates) {
            return this.iamIdentityCenterOptionsUpdates((UpdateIamIdentityCenterConfigOptions)((UpdateIamIdentityCenterConfigOptions.Builder)UpdateIamIdentityCenterConfigOptions.builder().applyMutation(iamIdentityCenterOptionsUpdates)).build());
        }

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

