/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.opensearch.dataprepper.expression.ExceptionOverview;

class ParseTreeCompositeException
extends RuntimeException {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private final Set<Throwable> exceptions;

    public ParseTreeCompositeException(List<Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            throw new IllegalArgumentException("exceptions is empty");
        }
        this.exceptions = exceptions.stream().map(this::mapNullToNullPointer).collect(Collectors.toSet());
    }

    private Throwable mapNullToNullPointer(@Nullable Throwable throwable) {
        if (throwable == null) {
            return new NullPointerException("Throwable was null!");
        }
        return throwable;
    }

    private String throwableListToString(Set<Throwable> exceptions) {
        StringBuilder aggregateMessage = new StringBuilder();
        aggregateMessage.append("Multiple exceptions (").append(exceptions.size()).append(")").append(SEPARATOR);
        for (Throwable inner : exceptions) {
            aggregateMessage.append("|-- ");
            aggregateMessage.append(inner.getClass().getCanonicalName()).append(": ");
            aggregateMessage.append(inner.getMessage());
            StackTraceElement[] stackTrace = inner.getStackTrace();
            if (stackTrace.length <= 0) continue;
            aggregateMessage.append(SEPARATOR).append("    at ").append(stackTrace[0]).append(SEPARATOR);
        }
        return aggregateMessage.toString().trim();
    }

    @Override
    public synchronized Throwable getCause() {
        if (this.exceptions.size() > 1) {
            String message = this.throwableListToString(this.exceptions);
            return new ExceptionOverview(message);
        }
        return this.exceptions.iterator().next();
    }
}

