/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.expression;

import com.google.common.base.Preconditions;
import javax.inject.Named;
import org.antlr.v4.runtime.RuleContext;
import org.opensearch.dataprepper.expression.Operator;
import org.opensearch.dataprepper.expression.antlr.DataPrepperExpressionParser;

@Named
class AndOperator
implements Operator<Boolean> {
    private static final int SYMBOL = 25;
    private static final String DISPLAY_NAME = DataPrepperExpressionParser.VOCABULARY.getDisplayName(25);

    AndOperator() {
    }

    @Override
    public boolean isBooleanOperator() {
        return true;
    }

    @Override
    public boolean shouldEvaluate(RuleContext ctx) {
        return ctx.getRuleIndex() == 6;
    }

    @Override
    public int getSymbol() {
        return 25;
    }

    @Override
    public Boolean evaluate(Object ... args) {
        Preconditions.checkArgument((args.length == 2 ? 1 : 0) != 0, (Object)(DISPLAY_NAME + " requires operands length to be 2."));
        Preconditions.checkArgument((boolean)(args[0] instanceof Boolean), (Object)(DISPLAY_NAME + " requires left operand to be Boolean."));
        Preconditions.checkArgument((boolean)(args[1] instanceof Boolean), (Object)(DISPLAY_NAME + " requires right operand to be Boolean."));
        return (Boolean)args[0] != false && (Boolean)args[1] != false;
    }
}

