/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.geoip.extension;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.opensearch.dataprepper.model.annotations.DataPrepperExtensionPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.model.plugin.ExtensionProvider;
import org.opensearch.dataprepper.plugins.geoip.extension.DefaultGeoIpConfigSupplier;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIPDatabaseManager;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIpConfigProvider;
import org.opensearch.dataprepper.plugins.geoip.extension.GeoIpServiceConfig;
import org.opensearch.dataprepper.plugins.geoip.extension.LicenseTypeCheck;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.DatabaseReaderBuilder;
import org.opensearch.dataprepper.plugins.geoip.extension.databasedownload.GeoIPFileManager;

@DataPrepperExtensionPlugin(modelType=GeoIpServiceConfig.class, rootKeyJsonPath="/geoip_service", allowInPipelineConfigurations=true)
public class GeoIpConfigExtension
implements ExtensionPlugin {
    private final DefaultGeoIpConfigSupplier defaultGeoIpConfigSupplier;

    @DataPrepperPluginConstructor
    public GeoIpConfigExtension(GeoIpServiceConfig geoIpServiceConfig) {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock(true);
        GeoIPDatabaseManager geoIPDatabaseManager = null;
        if (geoIpServiceConfig != null) {
            geoIPDatabaseManager = new GeoIPDatabaseManager(geoIpServiceConfig.getMaxMindConfig(), new LicenseTypeCheck(), new DatabaseReaderBuilder(), new GeoIPFileManager(), reentrantReadWriteLock.writeLock());
        }
        this.defaultGeoIpConfigSupplier = new DefaultGeoIpConfigSupplier(geoIpServiceConfig, geoIPDatabaseManager, reentrantReadWriteLock.readLock());
    }

    public void apply(ExtensionPoints extensionPoints) {
        extensionPoints.addExtensionProvider((ExtensionProvider)new GeoIpConfigProvider(this.defaultGeoIpConfigSupplier));
    }
}

