/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.dataprepper.plugins.source.rds.exception.SqlMetadataException;
import org.opensearch.dataprepper.plugins.source.rds.model.BinlogCoordinate;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyAction;
import org.opensearch.dataprepper.plugins.source.rds.model.ForeignKeyRelation;
import org.opensearch.dataprepper.plugins.source.rds.schema.ConnectionManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.SchemaManager;
import org.opensearch.dataprepper.plugins.source.rds.schema.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSchemaManager
implements SchemaManager {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSchemaManager.class);
    static final String[] TABLE_TYPES = new String[]{"TABLE"};
    static final String COLUMN_NAME = "COLUMN_NAME";
    static final String TABLE_NAME = "TABLE_NAME";
    static final String MYSQL_VERSION_8_4 = "8.4";
    static final String BINLOG_STATUS_QUERY = "SHOW MASTER STATUS";
    static final String NEW_BINLOG_STATUS_QUERY = "SHOW BINARY LOG STATUS";
    static final String BINLOG_FILE = "File";
    static final String BINLOG_POSITION = "Position";
    static final int NUM_OF_RETRIES = 3;
    static final int BACKOFF_IN_MILLIS = 500;
    static final String TYPE_NAME = "TYPE_NAME";
    static final String FKTABLE_NAME = "FKTABLE_NAME";
    static final String FKCOLUMN_NAME = "FKCOLUMN_NAME";
    static final String PKTABLE_NAME = "PKTABLE_NAME";
    static final String PKCOLUMN_NAME = "PKCOLUMN_NAME";
    static final String UPDATE_RULE = "UPDATE_RULE";
    static final String DELETE_RULE = "DELETE_RULE";
    static final String COLUMN_DEF = "COLUMN_DEF";
    private final ConnectionManager connectionManager;

    public MySqlSchemaManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public Map<String, List<String>> getPrimaryKeys(List<String> fullTableNames) {
        HashMap<String, List<String>> hashMap;
        block9: {
            HashMap<String, List<String>> tableToPrimaryKeysMap = new HashMap<String, List<String>>();
            Connection connection = this.connectionManager.getConnection();
            try {
                for (String fullTableName : fullTableNames) {
                    tableToPrimaryKeysMap.put(fullTableName, this.getPrimaryKeysForTable(connection, fullTableName));
                }
                hashMap = tableToPrimaryKeysMap;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to get connection while trying to get primary keys for tables. ", e);
                }
            }
            connection.close();
        }
        return hashMap;
    }

    private List<String> getPrimaryKeysForTable(Connection connection, String fullTableName) {
        String database = fullTableName.split("\\.")[0];
        String table = fullTableName.split("\\.")[1];
        int retry = 0;
        while (retry <= 3) {
            ArrayList<String> arrayList;
            block10: {
                ArrayList<String> primaryKeys = new ArrayList<String>();
                ResultSet rs = connection.getMetaData().getPrimaryKeys(database, null, table);
                try {
                    while (rs.next()) {
                        primaryKeys.add(rs.getString(COLUMN_NAME));
                    }
                    arrayList = primaryKeys;
                    if (rs == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to get primary keys for table {}, retrying", (Object)table, (Object)e);
                        this.applyBackoff();
                        ++retry;
                    }
                }
                rs.close();
            }
            return arrayList;
        }
        throw new SqlMetadataException("Failed to get primary keys for table " + table);
    }

    @Override
    public Map<String, Map<String, String>> getColumnDataTypes(List<String> fullTableNames) {
        HashMap<String, Map<String, String>> hashMap;
        block9: {
            HashMap<String, Map<String, String>> tableToColumnDataTypesMap = new HashMap<String, Map<String, String>>();
            Connection connection = this.connectionManager.getConnection();
            try {
                for (String fullTableName : fullTableNames) {
                    tableToColumnDataTypesMap.put(fullTableName, this.getColumnDataTypesForTable(connection, fullTableName));
                }
                hashMap = tableToColumnDataTypesMap;
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("Failed to get connection while trying to get column data types for tables. ", e);
                }
            }
            connection.close();
        }
        return hashMap;
    }

    private Map<String, String> getColumnDataTypesForTable(Connection connection, String fullTableName) {
        String database = fullTableName.split("\\.")[0];
        String tableName = fullTableName.split("\\.")[1];
        HashMap<String, String> columnsToDataType = new HashMap<String, String>();
        for (int retry = 0; retry <= 3; ++retry) {
            try {
                try (ResultSet columns = connection.getMetaData().getColumns(database, null, tableName, null);){
                    while (columns.next()) {
                        columnsToDataType.put(columns.getString(COLUMN_NAME), columns.getString(TYPE_NAME));
                    }
                }
                return columnsToDataType;
            }
            catch (Exception e) {
                LOG.error("Failed to get dataTypes for database {} table {}, retrying", new Object[]{database, tableName, e});
                this.applyBackoff();
                continue;
            }
        }
        throw new SqlMetadataException(String.format("Failed to get dataTypes for database %s table %s after %d retries", database, tableName, 3));
    }

    @Override
    public Set<String> getTableNames(String databaseName) {
        HashSet<String> tableNames = new HashSet<String>();
        int retry = 0;
        while (retry <= 3) {
            HashSet<String> hashSet;
            block17: {
                Connection connection = this.connectionManager.getConnection();
                try {
                    try (ResultSet tables = connection.getMetaData().getTables(databaseName, null, null, new String[]{"TABLE"});){
                        while (tables.next()) {
                            tableNames.add(databaseName + "." + tables.getString(TABLE_NAME));
                        }
                    }
                    hashSet = tableNames;
                    if (connection == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.warn("Failed to get table names, retrying", (Throwable)e);
                        tableNames.clear();
                        this.applyBackoff();
                        ++retry;
                    }
                }
                connection.close();
            }
            return hashSet;
        }
        throw new RuntimeException("Failed to get table names for database: " + databaseName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<BinlogCoordinate> getCurrentBinaryLogPosition() {
        int retry = 0;
        while (true) {
            if (retry > 3) {
                LOG.warn("Failed to get current binary log position");
                return Optional.empty();
            }
            try (Connection connection = this.connectionManager.getConnection();){
                ResultSet rs;
                String mySqlVersion = connection.getMetaData().getDatabaseProductVersion();
                LOG.info("MySQL version: {}", (Object)mySqlVersion);
                Statement statement = connection.createStatement();
                ResultSet resultSet = rs = VersionUtil.compareVersions(mySqlVersion, MYSQL_VERSION_8_4) >= 0 ? statement.executeQuery(NEW_BINLOG_STATUS_QUERY) : statement.executeQuery(BINLOG_STATUS_QUERY);
                if (rs.next()) {
                    Optional<BinlogCoordinate> optional = Optional.of(new BinlogCoordinate(rs.getString(BINLOG_FILE), rs.getLong(BINLOG_POSITION)));
                    return optional;
                }
            }
            catch (Exception e) {
                LOG.error("Failed to get current binary log position, retrying", (Throwable)e);
            }
            this.applyBackoff();
            ++retry;
        }
    }

    public List<ForeignKeyRelation> getForeignKeyRelations(List<String> tableNames) {
        int retry = 0;
        while (retry <= 3) {
            ArrayList<ForeignKeyRelation> arrayList;
            block13: {
                Connection connection = this.connectionManager.getConnection();
                try {
                    ArrayList<ForeignKeyRelation> foreignKeyRelations = new ArrayList<ForeignKeyRelation>();
                    DatabaseMetaData metaData = connection.getMetaData();
                    for (String tableName : tableNames) {
                        String database = tableName.split("\\.")[0];
                        String table = tableName.split("\\.")[1];
                        ResultSet tableResult = metaData.getTables(database, null, table, TABLE_TYPES);
                        while (tableResult.next()) {
                            ResultSet foreignKeys = metaData.getImportedKeys(database, null, table);
                            while (foreignKeys.next()) {
                                ResultSet columnResult;
                                String fkTableName = foreignKeys.getString(FKTABLE_NAME);
                                String fkColumnName = foreignKeys.getString(FKCOLUMN_NAME);
                                String pkTableName = foreignKeys.getString(PKTABLE_NAME);
                                String pkColumnName = foreignKeys.getString(PKCOLUMN_NAME);
                                ForeignKeyAction updateAction = ForeignKeyAction.getActionFromMetadata(foreignKeys.getShort(UPDATE_RULE));
                                ForeignKeyAction deleteAction = ForeignKeyAction.getActionFromMetadata(foreignKeys.getShort(DELETE_RULE));
                                Object defaultValue = null;
                                if ((updateAction == ForeignKeyAction.SET_DEFAULT || deleteAction == ForeignKeyAction.SET_DEFAULT) && (columnResult = metaData.getColumns(database, null, table, fkColumnName)).next()) {
                                    defaultValue = columnResult.getObject(COLUMN_DEF);
                                }
                                ForeignKeyRelation foreignKeyRelation = ForeignKeyRelation.builder().databaseName(database).parentTableName(pkTableName).referencedKeyName(pkColumnName).childTableName(fkTableName).foreignKeyName(fkColumnName).foreignKeyDefaultValue(defaultValue).updateAction(updateAction).deleteAction(deleteAction).build();
                                foreignKeyRelations.add(foreignKeyRelation);
                            }
                        }
                    }
                    arrayList = foreignKeyRelations;
                    if (connection == null) break block13;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error("Failed to scan foreign key references, retrying", (Throwable)e);
                        this.applyBackoff();
                        ++retry;
                    }
                }
                connection.close();
            }
            return arrayList;
        }
        LOG.warn("Failed to scan foreign key references");
        return List.of();
    }

    private void applyBackoff() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

