/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.leader;

import java.time.Instant;
import org.opensearch.dataprepper.plugins.source.rds.leader.RdsApiStrategy;
import org.opensearch.dataprepper.plugins.source.rds.model.DbMetadata;
import org.opensearch.dataprepper.plugins.source.rds.model.SnapshotInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.rds.RdsClient;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotRequest;
import software.amazon.awssdk.services.rds.model.CreateDbClusterSnapshotResponse;
import software.amazon.awssdk.services.rds.model.DBCluster;
import software.amazon.awssdk.services.rds.model.DBClusterSnapshot;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClusterSnapshotsResponse;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersRequest;
import software.amazon.awssdk.services.rds.model.DescribeDbClustersResponse;

public class ClusterApiStrategy
implements RdsApiStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterApiStrategy.class);
    private final RdsClient rdsClient;

    public ClusterApiStrategy(RdsClient rdsClient) {
        this.rdsClient = rdsClient;
    }

    @Override
    public DbMetadata describeDb(String dbIdentifier) {
        DescribeDbClustersRequest request = (DescribeDbClustersRequest)DescribeDbClustersRequest.builder().dbClusterIdentifier(dbIdentifier).build();
        try {
            DescribeDbClustersResponse response = this.rdsClient.describeDBClusters(request);
            DBCluster dbCluster = (DBCluster)response.dbClusters().get(0);
            return DbMetadata.builder().dbIdentifier(dbIdentifier).endpoint(dbCluster.endpoint()).port(dbCluster.port()).readerEndpoint(dbCluster.readerEndpoint()).readerPort(dbCluster.port()).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to describe DB " + dbIdentifier, e);
        }
    }

    @Override
    public SnapshotInfo createSnapshot(String dbIdentifier, String snapshotId) {
        CreateDbClusterSnapshotRequest request = (CreateDbClusterSnapshotRequest)CreateDbClusterSnapshotRequest.builder().dbClusterIdentifier(dbIdentifier).dbClusterSnapshotIdentifier(snapshotId).build();
        try {
            CreateDbClusterSnapshotResponse response = this.rdsClient.createDBClusterSnapshot(request);
            String snapshotArn = response.dbClusterSnapshot().dbClusterSnapshotArn();
            String status = response.dbClusterSnapshot().status();
            Instant createTime = response.dbClusterSnapshot().snapshotCreateTime();
            LOG.info("Creating snapshot with id {} for {} and the current status is {}", new Object[]{snapshotId, dbIdentifier, status});
            return new SnapshotInfo(snapshotId, snapshotArn, createTime, status);
        }
        catch (Exception e) {
            LOG.error("Failed to create snapshot for {}", (Object)dbIdentifier, (Object)e);
            return null;
        }
    }

    @Override
    public SnapshotInfo describeSnapshot(String snapshotId) {
        DescribeDbClusterSnapshotsRequest request = (DescribeDbClusterSnapshotsRequest)DescribeDbClusterSnapshotsRequest.builder().dbClusterSnapshotIdentifier(snapshotId).build();
        try {
            DescribeDbClusterSnapshotsResponse response = this.rdsClient.describeDBClusterSnapshots(request);
            String snapshotArn = ((DBClusterSnapshot)response.dbClusterSnapshots().get(0)).dbClusterSnapshotArn();
            String status = ((DBClusterSnapshot)response.dbClusterSnapshots().get(0)).status();
            Instant createTime = ((DBClusterSnapshot)response.dbClusterSnapshots().get(0)).snapshotCreateTime();
            return new SnapshotInfo(snapshotId, snapshotArn, createTime, status);
        }
        catch (Exception e) {
            LOG.error("Failed to describe snapshot {}", (Object)snapshotId, (Object)e);
            return null;
        }
    }
}

