/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.handler;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataType;
import org.opensearch.dataprepper.plugins.source.rds.datatype.mysql.MySQLDataTypeHandler;
import org.opensearch.dataprepper.plugins.source.rds.model.TableMetadata;

public class SpatialTypeHandler
implements MySQLDataTypeHandler {
    private static final int GEOMETRY_POINT = 1;
    private static final int GEOMETRY_LINESTRING = 2;
    private static final int GEOMETRY_POLYGON = 3;
    private static final int GEOMETRY_MULTIPOINT = 4;
    private static final int GEOMETRY_MULTILINESTRING = 5;
    private static final int GEOMETRY_MULTIPOLYGON = 6;
    private static final int GEOMETRY_COLLECTION = 7;

    @Override
    public String handle(MySQLDataType columnType, String columnName, Object value, TableMetadata metadata) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Object data = ((Map)value).get("bytes");
            if (data == null) {
                return null;
            }
            String val = data.toString();
            byte[] wkbBytes = new byte[val.length()];
            for (int i = 0; i < val.length(); ++i) {
                wkbBytes[i] = (byte)val.charAt(i);
            }
            return this.parseGeometry(wkbBytes, columnName);
        }
        if (value instanceof byte[]) {
            return this.parseGeometry((byte[])value, columnName);
        }
        throw new IllegalArgumentException("Unsupported value type. The value is of type: " + String.valueOf(value.getClass()));
    }

    private String parseGeometry(byte[] rawData, String columnName) {
        try {
            return this.parseGeometry(ByteBuffer.wrap(rawData).asReadOnlyBuffer());
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing the geometry data type value for columnName: " + columnName, e);
        }
    }

    private String parseGeometry(ByteBuffer buffer) {
        buffer.position(buffer.position() + 4);
        byte wkbByteOrder = buffer.get();
        ByteOrder order = wkbByteOrder == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
        buffer.order(order);
        int wkbType = buffer.getInt();
        switch (wkbType) {
            case 1: {
                return this.parsePoint(buffer);
            }
            case 2: {
                return this.parseLineString(buffer);
            }
            case 3: {
                return this.parsePolygon(buffer);
            }
            case 4: {
                return this.parseMultiPoint(buffer);
            }
            case 5: {
                return this.parseMultiLineString(buffer);
            }
            case 6: {
                return this.parseMultiPolygon(buffer);
            }
            case 7: {
                return this.parseGeometryCollection(buffer);
            }
        }
        throw new IllegalArgumentException("Unsupported WKB type: " + wkbType);
    }

    private String parseGeometryCollection(ByteBuffer buffer) {
        int numGeometries = buffer.getInt();
        if (numGeometries < 1) {
            throw new IllegalArgumentException("GeometryCollection must have at least 1 geometry");
        }
        ArrayList<String> geometries = new ArrayList<String>();
        for (int i = 0; i < numGeometries; ++i) {
            String geometry;
            byte geomByteOrder = buffer.get();
            buffer.order(geomByteOrder == 1 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN);
            int geomType = buffer.getInt();
            switch (geomType) {
                case 1: {
                    geometry = this.parsePoint(buffer);
                    break;
                }
                case 2: {
                    geometry = this.parseLineString(buffer);
                    break;
                }
                case 3: {
                    geometry = this.parsePolygon(buffer);
                    break;
                }
                case 4: {
                    geometry = this.parseMultiPoint(buffer);
                    break;
                }
                case 5: {
                    geometry = this.parseMultiLineString(buffer);
                    break;
                }
                case 6: {
                    geometry = this.parseMultiPolygon(buffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported geometry type in collection: " + geomType);
                }
            }
            geometries.add(geometry);
        }
        return this.formatGeometryCollection(geometries);
    }

    private String parsePoint(ByteBuffer buffer) {
        double x = buffer.getDouble();
        double y = buffer.getDouble();
        return String.format("POINT(%f %f)", x, y);
    }

    private String parseLineString(ByteBuffer buffer) {
        int numPoints = buffer.getInt();
        if (numPoints < 2) {
            throw new IllegalArgumentException("LineString must have at least 2 points");
        }
        List<Point> points = this.createPoints(buffer, numPoints);
        return this.formatLineString(points);
    }

    private String parsePolygon(ByteBuffer buffer) {
        int numRings = buffer.getInt();
        List<List<Point>> rings = this.parseLinearRing(buffer, numRings);
        return this.formatPolygon(rings);
    }

    private List<List<Point>> parseLinearRing(ByteBuffer buffer, int numRings) {
        if (numRings < 1) {
            throw new IllegalArgumentException("Polygon must have at least 1 ring");
        }
        ArrayList<List<Point>> rings = new ArrayList<List<Point>>();
        for (int ring = 0; ring < numRings; ++ring) {
            int numPoints = buffer.getInt();
            if (numPoints < 4) {
                throw new IllegalArgumentException("Polygon ring must have at least 4 points");
            }
            List<Point> points = this.createPoints(buffer, numPoints);
            rings.add(points);
        }
        return rings;
    }

    private String parseMultiPoint(ByteBuffer buffer) {
        int numPoints = buffer.getInt();
        if (numPoints < 1) {
            throw new IllegalArgumentException("MultiPoint must have at least 1 point");
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < numPoints; ++i) {
            buffer.position(buffer.position() + 5);
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            points.add(new Point(x, y));
        }
        return this.formatMultiPoint(points);
    }

    private String parseMultiLineString(ByteBuffer buffer) {
        int numLines = buffer.getInt();
        if (numLines < 1) {
            throw new IllegalArgumentException("MultiLineString must have at least 1 line");
        }
        ArrayList<List<Point>> lines = new ArrayList<List<Point>>();
        for (int i = 0; i < numLines; ++i) {
            buffer.position(buffer.position() + 5);
            int numPoints = buffer.getInt();
            if (numPoints < 2) {
                throw new IllegalArgumentException("LineString must have at least 2 points");
            }
            List<Point> points = this.createPoints(buffer, numPoints);
            lines.add(points);
        }
        return this.formatMultiLineString(lines);
    }

    private String parseMultiPolygon(ByteBuffer buffer) {
        int numPolygons = buffer.getInt();
        if (numPolygons < 1) {
            throw new IllegalArgumentException("MultiPolygon must have at least 1 polygon");
        }
        ArrayList<List<List<Point>>> polygons = new ArrayList<List<List<Point>>>();
        for (int i = 0; i < numPolygons; ++i) {
            buffer.position(buffer.position() + 5);
            int numRings = buffer.getInt();
            List<List<Point>> rings = this.parseLinearRing(buffer, numRings);
            polygons.add(rings);
        }
        return this.formatMultiPolygon(polygons);
    }

    private String formatGeometryCollection(List<String> geometries) {
        StringBuilder wkt = new StringBuilder("GEOMETRYCOLLECTION(");
        for (int i = 0; i < geometries.size(); ++i) {
            if (i > 0) {
                wkt.append(", ");
            }
            wkt.append(geometries.get(i));
        }
        wkt.append(")");
        return wkt.toString();
    }

    private String formatLineString(List<Point> points) {
        StringBuilder wkt = new StringBuilder("LINESTRING(");
        this.appendPoints(wkt, points);
        wkt.append(")");
        return wkt.toString();
    }

    private void appendPoints(StringBuilder wkt, List<Point> points) {
        for (int i = 0; i < points.size(); ++i) {
            if (i > 0) {
                wkt.append(", ");
            }
            Point p = points.get(i);
            wkt.append(SpatialTypeHandler.formatPoint(p));
        }
    }

    private void appendPointsList(StringBuilder wkt, List<List<Point>> rings) {
        for (int j = 0; j < rings.size(); ++j) {
            if (j > 0) {
                wkt.append(", ");
            }
            wkt.append("(");
            List<Point> ring = rings.get(j);
            this.appendPoints(wkt, ring);
            wkt.append(")");
        }
    }

    private static String formatPoint(Point p) {
        return String.format("%f %f", p.x, p.y);
    }

    private String formatPolygon(List<List<Point>> rings) {
        StringBuilder wkt = new StringBuilder("POLYGON(");
        this.appendPointsList(wkt, rings);
        wkt.append(")");
        return wkt.toString();
    }

    private String formatMultiPoint(List<Point> points) {
        StringBuilder wkt = new StringBuilder("MULTIPOINT(");
        this.appendPoints(wkt, points);
        wkt.append(")");
        return wkt.toString();
    }

    private String formatMultiLineString(List<List<Point>> lines) {
        StringBuilder wkt = new StringBuilder("MULTILINESTRING(");
        this.appendPointsList(wkt, lines);
        wkt.append(")");
        return wkt.toString();
    }

    private String formatMultiPolygon(List<List<List<Point>>> polygons) {
        StringBuilder wkt = new StringBuilder("MULTIPOLYGON(");
        for (int i = 0; i < polygons.size(); ++i) {
            if (i > 0) {
                wkt.append(", ");
            }
            wkt.append("(");
            List<List<Point>> rings = polygons.get(i);
            this.appendPointsList(wkt, rings);
            wkt.append(")");
        }
        wkt.append(")");
        return wkt.toString();
    }

    private List<Point> createPoints(ByteBuffer buffer, int numPoints) {
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < numPoints; ++i) {
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            points.add(new Point(x, y));
        }
        return points;
    }

    private static class Point {
        final double x;
        final double y;

        Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

