/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.rds.coordination.partition;

import java.util.Optional;
import org.opensearch.dataprepper.model.source.coordinator.SourcePartitionStoreItem;
import org.opensearch.dataprepper.model.source.coordinator.enhanced.EnhancedSourcePartition;
import org.opensearch.dataprepper.plugins.source.rds.coordination.state.ExportProgressState;

public class ExportPartition
extends EnhancedSourcePartition<ExportProgressState> {
    public static final String PARTITION_TYPE = "EXPORT";
    private static final String DB_CLUSTER = "cluster";
    private static final String DB_INSTANCE = "instance";
    private final String dbIdentifier;
    private final boolean isCluster;
    private final ExportProgressState progressState;

    public ExportPartition(String dbIdentifier, boolean isCluster, ExportProgressState progressState) {
        this.dbIdentifier = dbIdentifier;
        this.isCluster = isCluster;
        this.progressState = progressState;
    }

    public ExportPartition(SourcePartitionStoreItem sourcePartitionStoreItem) {
        this.setSourcePartitionStoreItem(sourcePartitionStoreItem);
        String[] keySplits = sourcePartitionStoreItem.getSourcePartitionKey().split("\\|");
        this.dbIdentifier = keySplits[0];
        this.isCluster = DB_CLUSTER.equals(keySplits[1]);
        this.progressState = (ExportProgressState)this.convertStringToPartitionProgressState(ExportProgressState.class, sourcePartitionStoreItem.getPartitionProgressState());
    }

    public String getPartitionType() {
        return PARTITION_TYPE;
    }

    public String getPartitionKey() {
        String dbType = this.isCluster ? DB_CLUSTER : DB_INSTANCE;
        return this.dbIdentifier + "|" + dbType;
    }

    public Optional<ExportProgressState> getProgressState() {
        if (this.progressState != null) {
            return Optional.of(this.progressState);
        }
        return Optional.empty();
    }

    public String getDbIdentifier() {
        return this.dbIdentifier;
    }
}

