/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.sink.sqs;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.opensearch.dataprepper.expression.ExpressionEvaluator;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.codec.OutputCodec;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.event.EventHandle;
import org.opensearch.dataprepper.model.failures.DlqObject;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.sink.OutputCodecContext;
import org.opensearch.dataprepper.model.sink.SinkContext;
import org.opensearch.dataprepper.plugins.accumulator.BufferFactory;
import org.opensearch.dataprepper.plugins.accumulator.InMemoryBufferFactory;
import org.opensearch.dataprepper.plugins.dlq.DlqPushHandler;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkBatch;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkBatchEntry;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkConfig;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkDlqData;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkExecutor;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsSinkMetrics;
import org.opensearch.dataprepper.plugins.sink.sqs.SqsThresholdConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsClient;

public class SqsSinkService
extends SqsSinkExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(SqsSinkService.class);
    public static final int MAX_BYTES_IN_BATCH = 262144;
    public static final int MAX_EVENT_SIZE = 262144;
    private final Map<String, SqsSinkBatch> batchUrlMap = new HashMap<String, SqsSinkBatch>();
    private final String queueUrl;
    private final String groupId;
    private final String deDupId;
    private final SqsClient sqsClient;
    private final boolean isDynamicGroupId;
    private final boolean isDynamicDeDupId;
    private final boolean isDynamicQueueUrl;
    private final ExpressionEvaluator expressionEvaluator;
    private final ReentrantLock reentrantLock;
    private final SqsThresholdConfig thresholdConfig;
    private final SqsSinkConfig sqsSinkConfig;
    private final SinkContext sinkContext;
    private final OutputCodec codec;
    private final BufferFactory inMemoryBufferFactory;
    private final SqsSinkMetrics sinkMetrics;
    private final DlqPushHandler dlqPushHandler;
    private final List<DlqObject> dlqObjects = new ArrayList<DlqObject>();

    public SqsSinkService(SqsSinkConfig sqsSinkConfig, SqsClient sqsClient, ExpressionEvaluator expressionEvaluator, OutputCodec codec, SinkContext sinkContext, DlqPushHandler dlqPushHandler, PluginMetrics pluginMetrics) {
        this.inMemoryBufferFactory = new InMemoryBufferFactory();
        this.sqsClient = sqsClient;
        this.dlqPushHandler = dlqPushHandler;
        this.sinkContext = sinkContext;
        this.expressionEvaluator = expressionEvaluator;
        this.thresholdConfig = sqsSinkConfig.getThresholdConfig();
        this.codec = codec;
        this.sqsSinkConfig = sqsSinkConfig;
        this.reentrantLock = new ReentrantLock();
        this.sinkMetrics = new SqsSinkMetrics(pluginMetrics);
        this.queueUrl = sqsSinkConfig.getQueueUrl();
        this.isDynamicQueueUrl = this.queueUrl.contains("${");
        if (this.isDynamicQueueUrl && !expressionEvaluator.isValidFormatExpression(this.queueUrl).booleanValue()) {
            throw new IllegalArgumentException("Invalid queue url expression");
        }
        this.groupId = sqsSinkConfig.getGroupId();
        boolean bl = this.isDynamicGroupId = this.groupId != null && this.groupId.contains("${");
        if (this.isDynamicGroupId && !expressionEvaluator.isValidFormatExpression(this.groupId).booleanValue()) {
            throw new IllegalArgumentException("Invalid groupId expression");
        }
        this.deDupId = sqsSinkConfig.getDeDuplicationId();
        boolean bl2 = this.isDynamicDeDupId = this.deDupId != null && this.deDupId.contains("${");
        if (this.isDynamicDeDupId && !expressionEvaluator.isValidFormatExpression(this.deDupId).booleanValue()) {
            throw new IllegalArgumentException("Invalid deduplicationId expression");
        }
    }

    @Override
    public boolean exceedsMaxEventSizeThreshold(long estimatedSize) {
        return estimatedSize > 262144L;
    }

    @Override
    public void pushDLQList() {
        if (this.dlqObjects.size() == 0) {
            return;
        }
        boolean result = this.dlqPushHandler.perform(this.dlqObjects);
        for (DlqObject dlqObject : this.dlqObjects) {
            dlqObject.releaseEventHandles(result);
        }
        this.dlqObjects.clear();
    }

    @Override
    public void pushFailedObjectsToDlq(Object object) {
        List failedBatches = (List)object;
        for (SqsSinkBatch failedBatch : failedBatches) {
            for (Map.Entry<String, SqsSinkBatchEntry> entry : failedBatch.getEntries().entrySet()) {
                this.addBatchEntryToDLQ(entry.getValue(), "Failed to write to sink after maxRetries");
            }
            this.batchUrlMap.remove(failedBatch.getQueueUrl());
        }
    }

    @Override
    public long getEstimatedSize(Event event) throws Exception {
        return this.codec.getEstimatedSize(event, new OutputCodecContext());
    }

    @Override
    public boolean willExceedMaxBatchSize(Event event, long estimatedSize) throws Exception {
        String qUrl = this.getQueueUrl(event, false);
        if (qUrl == null) {
            return false;
        }
        SqsSinkBatch batch = this.batchUrlMap.get(qUrl);
        if (batch == null) {
            return false;
        }
        boolean result = batch.willExceedLimits(estimatedSize);
        if (result) {
            batch.setFlushReady();
        }
        return result;
    }

    @Override
    public Object doFlushOnce(Object previousFailedBatches) {
        ArrayList<SqsSinkBatch> failedBatches = new ArrayList<SqsSinkBatch>();
        ArrayList<String> successQueueUrls = new ArrayList<String>();
        if (previousFailedBatches != null) {
            List pFailedBatches = (List)previousFailedBatches;
            for (SqsSinkBatch failedBatch : pFailedBatches) {
                if (!failedBatch.flushOnce()) {
                    failedBatches.add(failedBatch);
                    continue;
                }
                successQueueUrls.add(failedBatch.getQueueUrl());
            }
        } else {
            for (Map.Entry<String, SqsSinkBatch> qUrlEntry : this.batchUrlMap.entrySet()) {
                SqsSinkBatch batch = qUrlEntry.getValue();
                if (!batch.isReady()) continue;
                if (!batch.flushOnce()) {
                    failedBatches.add(batch);
                    continue;
                }
                successQueueUrls.add(batch.getQueueUrl());
            }
        }
        for (String qUrl : successQueueUrls) {
            this.batchUrlMap.remove(qUrl);
        }
        if (failedBatches.size() == 0) {
            return null;
        }
        return failedBatches;
    }

    private String getQueueUrl(Event event, boolean logError) {
        String qUrl;
        block3: {
            qUrl = this.queueUrl;
            if (this.isDynamicQueueUrl) {
                try {
                    qUrl = event.formatString(this.queueUrl, this.expressionEvaluator);
                }
                catch (Exception e) {
                    qUrl = null;
                    if (!logError) break block3;
                    LOG.error(DataPrepperMarkers.NOISY, "Invalid queueURL expression {} ", (Object)e.getMessage());
                    this.addEventToDLQList(event, e);
                }
            }
        }
        return qUrl;
    }

    private String getGroupId(Event event) {
        String gId = this.groupId;
        if (this.isDynamicGroupId) {
            try {
                gId = event.formatString(this.groupId, this.expressionEvaluator);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Invalid groupId expression {}, using random groupId ", (Object)e.getMessage());
            }
        }
        return gId;
    }

    private String getDeDupId(Event event) {
        String ddId = this.deDupId;
        if (this.isDynamicDeDupId) {
            try {
                ddId = event.formatString(this.deDupId, this.expressionEvaluator);
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Invalid deDupId expression {}, using random deDupId ", (Object)e.getMessage());
            }
        }
        return ddId;
    }

    @Override
    public int getMaxRetries() {
        return this.sqsSinkConfig.getMaxRetries();
    }

    Map<String, SqsSinkBatch> getBatchUrlMap() {
        return this.batchUrlMap;
    }

    @Override
    public boolean addToBuffer(Event event, long estimatedSize) throws Exception {
        String ddId;
        String gId;
        boolean isFull;
        String qUrl = this.getQueueUrl(event, true);
        if (qUrl == null) {
            return false;
        }
        SqsSinkBatch batch = this.batchUrlMap.get(qUrl);
        if (batch == null) {
            OutputCodecContext codecContext = OutputCodecContext.fromSinkContext((SinkContext)this.sinkContext);
            batch = new SqsSinkBatch(this.inMemoryBufferFactory, this.sqsClient, this.sinkMetrics, qUrl, this.codec, codecContext, this.thresholdConfig, (batchEntry, exceptionMessage) -> this.addBatchEntryToDLQ((SqsSinkBatchEntry)batchEntry, (String)exceptionMessage));
            this.batchUrlMap.put(qUrl, batch);
        }
        if (isFull = batch.addEntry(event, gId = this.getGroupId(event), ddId = this.getDeDupId(event), estimatedSize)) {
            batch.setFlushReady();
        }
        return isFull;
    }

    @Override
    public boolean exceedsFlushTimeInterval() {
        long nowMillis = Instant.now().toEpochMilli();
        boolean result = false;
        for (Map.Entry<String, SqsSinkBatch> qUrlEntry : this.batchUrlMap.entrySet()) {
            String qUrl = qUrlEntry.getKey();
            SqsSinkBatch batch = qUrlEntry.getValue();
            if (nowMillis - batch.getLastFlushedTime() <= this.thresholdConfig.getFlushInterval() * 1000L) continue;
            batch.setFlushReady();
            result = true;
        }
        return result;
    }

    private void addBatchEntryToDLQ(SqsSinkBatchEntry batchEntry, String errorMessage) {
        this.addMessageToDLQ(batchEntry.getBody(), batchEntry.getEventHandles(), errorMessage);
    }

    private void addMessageToDLQ(String message, List<EventHandle> eventHandles, String errorMessage) {
        if (this.dlqPushHandler != null) {
            SqsSinkDlqData sqsSinkDlqData = SqsSinkDlqData.createDlqData(message, errorMessage);
            DlqObject dlqObject = DlqObject.createDlqObject((PluginSetting)this.dlqPushHandler.getPluginSetting(), eventHandles, (Object)sqsSinkDlqData);
            this.dlqObjects.add(dlqObject);
        } else {
            for (EventHandle handle : eventHandles) {
                handle.release(false);
            }
        }
    }

    @Override
    public void recordLatency(long amount, TimeUnit timeUnit) {
        this.sinkMetrics.recordRequestLatency(amount, timeUnit);
    }

    @Override
    public void addEventToDLQList(Event event, Throwable ex) {
        ArrayList<EventHandle> eventHandles = new ArrayList<EventHandle>();
        eventHandles.add(event.getEventHandle());
        this.addMessageToDLQ(event.toJsonString(), eventHandles, ex.getMessage());
    }

    @Override
    public void lock() {
        this.reentrantLock.lock();
    }

    @Override
    public void unlock() {
        this.reentrantLock.unlock();
    }

    void output(Collection<Record<Event>> records) {
        this.execute(records);
    }
}

