/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.grpc;

import com.google.protobuf.DescriptorProtos;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.docs.DocStringExtractor;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class GrpcDocStringExtractor
extends DocStringExtractor {
    private static final Logger logger = LoggerFactory.getLogger(GrpcDocStringExtractor.class);
    private static final Set<String> acceptableExtensions = ImmutableSet.of((Object)".bin", (Object)".desc", (Object)".dsc", (Object)".pb", (Object)".protobin");

    GrpcDocStringExtractor() {
        super("META-INF/armeria/grpc", "com.linecorp.armeria.grpc.descriptorDir");
    }

    protected boolean acceptFile(String filename) {
        return acceptableExtensions.stream().anyMatch(filename::endsWith);
    }

    protected Map<String, String> getDocStringsFromFiles(Map<String, byte[]> files) {
        return (Map)files.entrySet().stream().flatMap(entry -> {
            try {
                DescriptorProtos.FileDescriptorSet descriptors = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])((byte[])entry.getValue()));
                return descriptors.getFileList().stream();
            }
            catch (IOException e) {
                logger.info("Could not parse file at '{}', skipping. Is the file a protobuf descriptor file?", entry.getKey());
                return Stream.empty();
            }
        }).flatMap(f -> GrpcDocStringExtractor.parseFile(f).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (entry, unused) -> entry));
    }

    private static Map<String, String> parseFile(DescriptorProtos.FileDescriptorProto descriptor) {
        return (Map)descriptor.getSourceCodeInfo().getLocationList().stream().filter(l -> !l.getLeadingComments().isEmpty()).map(l -> {
            String fullName = GrpcDocStringExtractor.getFullName(descriptor, l.getPathList());
            if (fullName != null) {
                return new AbstractMap.SimpleImmutableEntry<String, String>(fullName, l.getLeadingComments());
            }
            return null;
        }).filter(Objects::nonNull).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (first, second) -> {
            logger.warn("Multiple keys found while parsing proto comments, skipping entry \"{}\".", second);
            return first;
        }));
    }

    @Nullable
    private static String getFullName(DescriptorProtos.FileDescriptorProto descriptor, List<Integer> path) {
        String fullNameSoFar = descriptor.getPackage();
        switch (path.get(0)) {
            case 4: {
                DescriptorProtos.DescriptorProto message = descriptor.getMessageType(path.get(1).intValue());
                return GrpcDocStringExtractor.appendMessageToFullName(message, path, fullNameSoFar);
            }
            case 5: {
                DescriptorProtos.EnumDescriptorProto enumDescriptor = descriptor.getEnumType(path.get(1).intValue());
                return GrpcDocStringExtractor.appendEnumToFullName(enumDescriptor, path, fullNameSoFar);
            }
            case 6: {
                DescriptorProtos.ServiceDescriptorProto serviceDescriptor = descriptor.getService(path.get(1).intValue());
                fullNameSoFar = GrpcDocStringExtractor.appendNameComponent(fullNameSoFar, serviceDescriptor.getName());
                if (path.size() > 2) {
                    fullNameSoFar = GrpcDocStringExtractor.appendMethodToFullName(serviceDescriptor, path, fullNameSoFar);
                }
                return fullNameSoFar;
            }
        }
        return null;
    }

    @Nullable
    private static String appendMethodToFullName(DescriptorProtos.ServiceDescriptorProto serviceDescriptorProto, List<Integer> path, String fullNameSoFar) {
        if (path.size() == 4 && path.get(2) == 2) {
            return GrpcDocStringExtractor.appendFieldComponent(fullNameSoFar, serviceDescriptorProto.getMethod(path.get(3).intValue()).getName());
        }
        return null;
    }

    @Nullable
    private static String appendToFullName(DescriptorProtos.DescriptorProto messageDescriptor, List<Integer> path, String fullNameSoFar) {
        switch (path.get(0)) {
            case 3: {
                DescriptorProtos.DescriptorProto nestedMessage = messageDescriptor.getNestedType(path.get(1).intValue());
                return GrpcDocStringExtractor.appendMessageToFullName(nestedMessage, path, fullNameSoFar);
            }
            case 4: {
                DescriptorProtos.EnumDescriptorProto enumDescriptor = messageDescriptor.getEnumType(path.get(1).intValue());
                return GrpcDocStringExtractor.appendEnumToFullName(enumDescriptor, path, fullNameSoFar);
            }
            case 2: {
                DescriptorProtos.FieldDescriptorProto fieldDescriptor = messageDescriptor.getField(path.get(1).intValue());
                return GrpcDocStringExtractor.appendFieldComponent(fullNameSoFar, fieldDescriptor.getName());
            }
        }
        return null;
    }

    @Nullable
    private static String appendMessageToFullName(DescriptorProtos.DescriptorProto message, List<Integer> path, String fullNameSoFar) {
        fullNameSoFar = GrpcDocStringExtractor.appendNameComponent(fullNameSoFar, message.getName());
        return path.size() > 2 ? GrpcDocStringExtractor.appendToFullName(message, path.subList(2, path.size()), fullNameSoFar) : fullNameSoFar;
    }

    @Nullable
    private static String appendEnumToFullName(DescriptorProtos.EnumDescriptorProto enumDescriptor, List<Integer> path, String fullNameSoFar) {
        fullNameSoFar = GrpcDocStringExtractor.appendNameComponent(fullNameSoFar, enumDescriptor.getName());
        if (path.size() <= 2) {
            return fullNameSoFar;
        }
        if (path.get(2) == 2) {
            return GrpcDocStringExtractor.appendFieldComponent(fullNameSoFar, enumDescriptor.getValue(path.get(3).intValue()).getName());
        }
        return null;
    }

    private static String appendNameComponent(String nameSoFar, String component) {
        return nameSoFar + '.' + component;
    }

    private static String appendFieldComponent(String nameSoFar, String component) {
        return nameSoFar + '/' + component;
    }
}

