/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.examples.parkservices;

import com.amazon.randomcutforest.config.ForestMode;
import com.amazon.randomcutforest.config.Precision;
import com.amazon.randomcutforest.examples.Example;
import com.amazon.randomcutforest.parkservices.AnomalyDescriptor;
import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.amazon.randomcutforest.testutils.MultiDimDataWithKey;
import com.amazon.randomcutforest.testutils.NormalMixtureTestData;
import java.util.Random;

public class ThresholdedTime
implements Example {
    public static void main(String[] args) throws Exception {
        new ThresholdedTime().run();
    }

    @Override
    public String command() {
        return "Thresholded_Time_example";
    }

    @Override
    public String description() {
        return "Thresholded Time Example";
    }

    @Override
    public void run() throws Exception {
        int shingleSize = 4;
        int numberOfTrees = 50;
        int sampleSize = 256;
        Precision precision = Precision.FLOAT_32;
        int dataSize = 4 * sampleSize;
        int baseDimensions = 1;
        int count = 0;
        int dimensions = baseDimensions * shingleSize;
        ThresholdedRandomCutForest forest = new ThresholdedRandomCutForest.Builder().compact(true).dimensions(dimensions).randomSeed(0L).numberOfTrees(numberOfTrees).shingleSize(shingleSize).sampleSize(sampleSize).internalShinglingEnabled(true).precision(precision).anomalyRate(0.01).forestMode(ForestMode.TIME_AUGMENTED).normalizeTime(true).build();
        long seed = new Random().nextLong();
        double[] data = new double[]{1.0};
        System.out.println("seed = " + seed);
        NormalMixtureTestData normalMixtureTestData = new NormalMixtureTestData(10.0, 50.0);
        MultiDimDataWithKey dataWithKeys = normalMixtureTestData.generateTestDataWithKey(dataSize, 1, 0);
        boolean anomalyState = false;
        int keyCounter = 0;
        for (double[] point : dataWithKeys.data) {
            long time = (long)((double)(1000L * (long)count) + Math.floor(10.0 * point[0]));
            AnomalyDescriptor result = forest.process(data, time);
            if (keyCounter < dataWithKeys.changeIndices.length && count == dataWithKeys.changeIndices[keyCounter]) {
                System.out.print("Sequence " + count + " stamp " + result.getInternalTimeStamp() + " CHANGE ");
                if (!anomalyState) {
                    System.out.println(" to Distribution 1 ");
                } else {
                    System.out.println(" to Distribution 0 ");
                }
                anomalyState = !anomalyState;
                ++keyCounter;
            }
            if (result.getAnomalyGrade() != 0.0) {
                System.out.print("Sequence " + count + " stamp " + result.getInternalTimeStamp() + " RESULT ");
                System.out.print("score " + result.getRCFScore() + ", grade " + result.getAnomalyGrade() + ", ");
                if (result.isExpectedValuesPresent()) {
                    if (result.getRelativeIndex() != 0 && result.isStartOfAnomaly()) {
                        System.out.print(-result.getRelativeIndex() + " steps ago, instead of stamp " + result.getPastTimeStamp());
                        System.out.print(", expected timestamp " + result.getExpectedTimeStamp() + " ( " + (result.getPastTimeStamp() - result.getExpectedTimeStamp()) + ")");
                    } else {
                        System.out.print("expected " + result.getExpectedTimeStamp() + " ( " + (result.getInternalTimeStamp() - result.getExpectedTimeStamp()) + ")");
                    }
                }
                System.out.println();
            }
            ++count;
        }
    }
}

