/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry;

import java.util.Optional;

public class RetryDecision {
    private final boolean shouldStop;
    private final Optional<Exception> exception;

    private RetryDecision(boolean shouldStop, Optional<Exception> exception) {
        this.shouldStop = shouldStop;
        this.exception = exception;
    }

    public static RetryDecision retry() {
        return new RetryDecision(false, Optional.empty());
    }

    public static RetryDecision stop() {
        return new RetryDecision(true, Optional.empty());
    }

    public static RetryDecision stopWithException(Exception exception) {
        return new RetryDecision(true, Optional.ofNullable(exception));
    }

    public boolean isShouldStop() {
        return this.shouldStop;
    }

    public Optional<Exception> getException() {
        return this.exception;
    }
}

