/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.source_crawler.metrics;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpClientErrorException;

@Named
public class VendorAPIMetricsRecorder {
    private final Counter searchSuccessCounter;
    private final Counter searchFailureCounter;
    private final Timer searchLatencyTimer;
    private final DistributionSummary searchResponseSizeSummary;
    private final Counter getSuccessCounter;
    private final Counter getFailureCounter;
    private final Timer getLatencyTimer;
    private final DistributionSummary getResponseSizeSummary;
    private final Counter authSuccessCounter;
    private final Counter authFailureCounter;
    private final Timer authLatencyTimer;
    private Counter subscriptionSuccessCounter;
    private Counter subscriptionFailureCounter;
    private Timer subscriptionLatencyTimer;
    private Counter subscriptionCallsCounter;
    private Counter listSubscriptionSuccessCounter;
    private Counter listSubscriptionFailureCounter;
    private Timer listSubscriptionLatencyTimer;
    private Counter listSubscriptionCallsCounter;
    private final Timer bufferWriteLatencyTimer;
    private final Counter bufferWriteAttemptsCounter;
    private final Counter bufferWriteSuccessCounter;
    private final Counter bufferWriteRetrySuccessCounter;
    private final Counter bufferWriteRetryAttemptsCounter;
    private final Counter bufferWriteFailuresCounter;
    private final Counter totalDataApiRequestsCounter;
    private final Counter logsRequestedCounter;
    private final Counter requestAccessDeniedCounter;
    private final Counter requestThrottledCounter;
    private final Counter resourceNotFoundCounter;
    private final Counter nonRetryableErrorsCounter;
    private final Counter retryableErrorsCounter;
    private final PluginMetrics pluginMetrics;
    private boolean enableSubscriptionMetrics;

    @Inject
    public VendorAPIMetricsRecorder(PluginMetrics pluginMetrics) {
        this(pluginMetrics, false);
    }

    public VendorAPIMetricsRecorder(PluginMetrics pluginMetrics, boolean enableSubscriptionMetrics) {
        this.pluginMetrics = pluginMetrics;
        this.enableSubscriptionMetrics = enableSubscriptionMetrics;
        this.searchSuccessCounter = pluginMetrics.counter("searchRequestsSuccess");
        this.searchFailureCounter = pluginMetrics.counter("searchRequestsFailed");
        this.searchLatencyTimer = pluginMetrics.timer("searchRequestLatency");
        this.searchResponseSizeSummary = pluginMetrics.summary("searchResponseSizeBytes");
        this.getSuccessCounter = pluginMetrics.counter("getRequestsSuccess");
        this.getFailureCounter = pluginMetrics.counter("getRequestsFailed");
        this.getLatencyTimer = pluginMetrics.timer("getRequestLatency");
        this.getResponseSizeSummary = pluginMetrics.summary("getResponseSizeBytes");
        this.authSuccessCounter = pluginMetrics.counter("authenticationRequestsSuccess");
        this.authFailureCounter = pluginMetrics.counter("authenticationRequestsFailed");
        this.authLatencyTimer = pluginMetrics.timer("authenticationRequestLatency");
        if (enableSubscriptionMetrics) {
            this.subscriptionSuccessCounter = pluginMetrics.counter("startSubscriptionRequestsSuccess");
            this.subscriptionFailureCounter = pluginMetrics.counter("startSubscriptionRequestsFailed");
            this.subscriptionLatencyTimer = pluginMetrics.timer("startSubscriptionRequestLatency");
            this.subscriptionCallsCounter = pluginMetrics.counter("startSubscriptionApiCalls");
            this.listSubscriptionSuccessCounter = pluginMetrics.counter("listSubscriptionRequestsSuccess");
            this.listSubscriptionFailureCounter = pluginMetrics.counter("listSubscriptionRequestsFailed");
            this.listSubscriptionLatencyTimer = pluginMetrics.timer("listSubscriptionRequestLatency");
            this.listSubscriptionCallsCounter = pluginMetrics.counter("listSubscriptionApiCalls");
        } else {
            this.subscriptionSuccessCounter = null;
            this.subscriptionFailureCounter = null;
            this.subscriptionLatencyTimer = null;
            this.subscriptionCallsCounter = null;
            this.listSubscriptionSuccessCounter = null;
            this.listSubscriptionFailureCounter = null;
            this.listSubscriptionLatencyTimer = null;
            this.listSubscriptionCallsCounter = null;
        }
        this.bufferWriteLatencyTimer = pluginMetrics.timer("bufferWriteLatency");
        this.bufferWriteAttemptsCounter = pluginMetrics.counter("bufferWriteAttempts");
        this.bufferWriteSuccessCounter = pluginMetrics.counter("bufferWriteSuccess");
        this.bufferWriteRetrySuccessCounter = pluginMetrics.counter("bufferWriteRetrySuccess");
        this.bufferWriteRetryAttemptsCounter = pluginMetrics.counter("bufferWriteRetryAttempts");
        this.bufferWriteFailuresCounter = pluginMetrics.counter("bufferWriteFailures");
        this.totalDataApiRequestsCounter = pluginMetrics.counter("totalDataApiRequests");
        this.logsRequestedCounter = pluginMetrics.counter("logsRequested");
        this.requestAccessDeniedCounter = pluginMetrics.counter("requestAccessDenied");
        this.requestThrottledCounter = pluginMetrics.counter("requestThrottled");
        this.resourceNotFoundCounter = pluginMetrics.counter("resourceNotFound");
        this.nonRetryableErrorsCounter = pluginMetrics.counter("nonRetryableErrors");
        this.retryableErrorsCounter = pluginMetrics.counter("retryableErrors");
    }

    public void enableSubscriptionMetrics() {
        if (!this.enableSubscriptionMetrics && this.subscriptionSuccessCounter == null) {
            this.initializeSubscriptionMetrics();
        }
        this.enableSubscriptionMetrics = true;
    }

    private void initializeSubscriptionMetrics() {
        this.subscriptionSuccessCounter = this.pluginMetrics.counter("startSubscriptionRequestsSuccess");
        this.subscriptionFailureCounter = this.pluginMetrics.counter("startSubscriptionRequestsFailed");
        this.subscriptionLatencyTimer = this.pluginMetrics.timer("startSubscriptionRequestLatency");
        this.subscriptionCallsCounter = this.pluginMetrics.counter("startSubscriptionApiCalls");
        this.listSubscriptionSuccessCounter = this.pluginMetrics.counter("listSubscriptionRequestsSuccess");
        this.listSubscriptionFailureCounter = this.pluginMetrics.counter("listSubscriptionRequestsFailed");
        this.listSubscriptionLatencyTimer = this.pluginMetrics.timer("listSubscriptionRequestLatency");
        this.listSubscriptionCallsCounter = this.pluginMetrics.counter("listSubscriptionApiCalls");
    }

    public void recordSearchSuccess() {
        this.searchSuccessCounter.increment();
    }

    public void recordSearchFailure() {
        this.searchFailureCounter.increment();
    }

    public <T> T recordSearchLatency(Supplier<T> operation) {
        return (T)this.searchLatencyTimer.record(operation);
    }

    public void recordSearchLatency(Runnable operation) {
        this.searchLatencyTimer.record(operation);
    }

    public void recordSearchLatency(Duration duration) {
        this.searchLatencyTimer.record(duration);
    }

    public void recordSearchResponseSize(ResponseEntity<?> response) {
        if (response != null) {
            String contentLength = response.getHeaders().getFirst("Content-Length");
            if (contentLength != null) {
                try {
                    this.searchResponseSizeSummary.record((double)Long.parseLong(contentLength));
                }
                catch (NumberFormatException e) {
                    this.searchResponseSizeSummary.record(0.0);
                }
            } else {
                this.searchResponseSizeSummary.record(0.0);
            }
        } else {
            this.searchResponseSizeSummary.record(0.0);
        }
    }

    public void recordSearchResponseSize(long bytes) {
        this.searchResponseSizeSummary.record((double)bytes);
    }

    public void recordSearchResponseSize(String response) {
        if (response != null) {
            this.searchResponseSizeSummary.record((double)response.getBytes().length);
        } else {
            this.searchResponseSizeSummary.record(0.0);
        }
    }

    public void recordGetSuccess() {
        this.getSuccessCounter.increment();
    }

    public void recordGetFailure() {
        this.getFailureCounter.increment();
    }

    public <T> T recordGetLatency(Supplier<T> operation) {
        return (T)this.getLatencyTimer.record(operation);
    }

    public void recordGetLatency(Runnable operation) {
        this.getLatencyTimer.record(operation);
    }

    public void recordGetLatency(Duration duration) {
        this.getLatencyTimer.record(duration);
    }

    public void recordGetResponseSize(String response) {
        if (response != null) {
            this.getResponseSizeSummary.record((double)response.getBytes().length);
        } else {
            this.getResponseSizeSummary.record(0.0);
        }
    }

    public void recordGetResponseSize(long bytes) {
        this.getResponseSizeSummary.record((double)bytes);
    }

    public void recordGetResponseSize(ResponseEntity<?> response) {
        if (response != null && response.getBody() != null) {
            this.getResponseSizeSummary.record((double)response.getHeaders().getContentLength());
        } else {
            this.getResponseSizeSummary.record(0.0);
        }
    }

    public void recordAuthSuccess() {
        this.authSuccessCounter.increment();
    }

    public void recordAuthFailure() {
        this.authFailureCounter.increment();
    }

    public <T> T recordAuthLatency(Supplier<T> operation) {
        return (T)this.authLatencyTimer.record(operation);
    }

    public void recordAuthLatency(Runnable operation) {
        this.authLatencyTimer.record(operation);
    }

    public void recordAuthLatency(Duration duration) {
        this.authLatencyTimer.record(duration);
    }

    public void recordSubscriptionSuccess() {
        if (this.enableSubscriptionMetrics && this.subscriptionSuccessCounter != null) {
            this.subscriptionSuccessCounter.increment();
        }
    }

    public void recordSubscriptionFailure() {
        if (this.enableSubscriptionMetrics && this.subscriptionFailureCounter != null) {
            this.subscriptionFailureCounter.increment();
        }
    }

    public <T> T recordSubscriptionLatency(Supplier<T> operation) {
        if (this.enableSubscriptionMetrics && this.subscriptionLatencyTimer != null) {
            return (T)this.subscriptionLatencyTimer.record(operation);
        }
        return operation.get();
    }

    public void recordSubscriptionLatency(Runnable operation) {
        if (this.enableSubscriptionMetrics && this.subscriptionLatencyTimer != null) {
            this.subscriptionLatencyTimer.record(operation);
        } else {
            operation.run();
        }
    }

    public void recordSubscriptionLatency(Duration duration) {
        if (this.enableSubscriptionMetrics && this.subscriptionLatencyTimer != null) {
            this.subscriptionLatencyTimer.record(duration);
        }
    }

    public void recordSubscriptionCall() {
        if (this.enableSubscriptionMetrics && this.subscriptionCallsCounter != null) {
            this.subscriptionCallsCounter.increment();
        }
    }

    public void recordListSubscriptionSuccess() {
        if (this.enableSubscriptionMetrics && this.listSubscriptionSuccessCounter != null) {
            this.listSubscriptionSuccessCounter.increment();
        }
    }

    public void recordListSubscriptionFailure() {
        if (this.enableSubscriptionMetrics && this.listSubscriptionFailureCounter != null) {
            this.listSubscriptionFailureCounter.increment();
        }
    }

    public <T> T recordListSubscriptionLatency(Supplier<T> operation) {
        if (this.enableSubscriptionMetrics && this.listSubscriptionLatencyTimer != null) {
            return (T)this.listSubscriptionLatencyTimer.record(operation);
        }
        return operation.get();
    }

    public void recordListSubscriptionLatency(Runnable operation) {
        if (this.enableSubscriptionMetrics && this.listSubscriptionLatencyTimer != null) {
            this.listSubscriptionLatencyTimer.record(operation);
        } else {
            operation.run();
        }
    }

    public void recordListSubscriptionLatency(Duration duration) {
        if (this.enableSubscriptionMetrics && this.listSubscriptionLatencyTimer != null) {
            this.listSubscriptionLatencyTimer.record(duration);
        }
    }

    public void recordListSubscriptionCall() {
        if (this.enableSubscriptionMetrics && this.listSubscriptionCallsCounter != null) {
            this.listSubscriptionCallsCounter.increment();
        }
    }

    public void recordDataApiRequest() {
        this.totalDataApiRequestsCounter.increment();
    }

    public void recordLogsRequested() {
        this.logsRequestedCounter.increment();
    }

    public void recordLogsRequested(int count) {
        this.logsRequestedCounter.increment((double)count);
    }

    public void recordBufferWriteAttempt() {
        this.bufferWriteAttemptsCounter.increment();
    }

    public void recordBufferWriteSuccess() {
        this.bufferWriteSuccessCounter.increment();
    }

    public void recordBufferWriteRetrySuccess() {
        this.bufferWriteRetrySuccessCounter.increment();
    }

    public void recordBufferWriteRetryAttempt() {
        this.bufferWriteRetryAttemptsCounter.increment();
    }

    public void recordBufferWriteFailure() {
        this.bufferWriteFailuresCounter.increment();
    }

    public <T> T recordBufferWriteLatency(Supplier<T> operation) {
        return (T)this.bufferWriteLatencyTimer.record(operation);
    }

    public void recordBufferWriteLatency(Runnable operation) {
        this.bufferWriteLatencyTimer.record(operation);
    }

    public void recordBufferWriteLatency(Duration duration) {
        this.bufferWriteLatencyTimer.record(duration);
    }

    public void recordNonRetryableError() {
        this.nonRetryableErrorsCounter.increment();
    }

    public void recordRetryableError() {
        this.retryableErrorsCounter.increment();
    }

    public void recordError(Exception exception) {
        if (exception instanceof HttpClientErrorException) {
            HttpClientErrorException httpE = (HttpClientErrorException)exception;
            HttpStatus status = httpE.getStatusCode();
            if (HttpStatus.FORBIDDEN == status || HttpStatus.UNAUTHORIZED == status) {
                this.requestAccessDeniedCounter.increment();
            } else if (HttpStatus.TOO_MANY_REQUESTS == status) {
                this.requestThrottledCounter.increment();
            } else if (HttpStatus.NOT_FOUND == status) {
                this.resourceNotFoundCounter.increment();
            }
        } else if (exception instanceof SecurityException) {
            this.requestAccessDeniedCounter.increment();
        }
    }
}

