/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.sqs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSet;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.plugins.source.sqs.AttributeHandler;
import org.opensearch.dataprepper.plugins.source.sqs.MessageFieldStrategy;
import org.opensearch.dataprepper.plugins.source.sqs.SqsMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.model.Message;

public class RawSqsMessageHandler
implements SqsMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RawSqsMessageHandler.class);
    private final MessageFieldStrategy messageFieldStrategy;

    public RawSqsMessageHandler(MessageFieldStrategy messageFieldStrategy) {
        this.messageFieldStrategy = messageFieldStrategy;
    }

    @Override
    public void handleMessage(Message message, String url, Buffer<Record<Event>> buffer, int bufferTimeoutMillis, AcknowledgementSet acknowledgementSet) {
        try {
            List<Event> events = this.messageFieldStrategy.parseEvents(message.body());
            Map<String, String> metadataMap = AttributeHandler.collectMetadataAttributes(message, url);
            ArrayList<Record> records = new ArrayList<Record>();
            for (Event event : events) {
                AttributeHandler.applyMetadataAttributes(event, metadataMap);
                if (acknowledgementSet != null) {
                    acknowledgementSet.add(event);
                }
                records.add(new Record((Object)event));
            }
            buffer.writeAll(records, bufferTimeoutMillis);
        }
        catch (Exception e) {
            LOG.error("Error processing SQS message: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException(e);
        }
    }
}

