/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.opensearch.dataprepper.core.validation.PluginErrorCollector;
import org.opensearch.dataprepper.model.plugin.ExtensionPlugin;
import org.opensearch.dataprepper.model.plugin.ExtensionPoints;
import org.opensearch.dataprepper.plugin.DataPrepperExtensionPoints;
import org.opensearch.dataprepper.plugin.ExtensionLoader;
import org.opensearch.dataprepper.validation.PluginError;
import org.opensearch.dataprepper.validation.PluginErrorsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="extensionsApplier")
class ExtensionsApplier {
    private static final Logger LOG = LoggerFactory.getLogger(ExtensionsApplier.class);
    private final DataPrepperExtensionPoints dataPrepperExtensionPoints;
    private final ExtensionLoader extensionLoader;
    private final PluginErrorCollector pluginErrorCollector;
    private final PluginErrorsHandler pluginErrorsHandler;
    private List<? extends ExtensionPlugin> loadedExtensionPlugins = Collections.emptyList();

    @Inject
    ExtensionsApplier(DataPrepperExtensionPoints dataPrepperExtensionPoints, ExtensionLoader extensionLoader, PluginErrorCollector pluginErrorCollector, PluginErrorsHandler pluginErrorsHandler) {
        this.dataPrepperExtensionPoints = dataPrepperExtensionPoints;
        this.extensionLoader = extensionLoader;
        this.pluginErrorCollector = pluginErrorCollector;
        this.pluginErrorsHandler = pluginErrorsHandler;
    }

    @PostConstruct
    void applyExtensions() {
        this.loadedExtensionPlugins = this.extensionLoader.loadExtensions();
        LOG.info("Loaded {} extensions: {}", (Object)this.loadedExtensionPlugins.size(), this.loadedExtensionPlugins);
        for (ExtensionPlugin extensionPlugin : this.loadedExtensionPlugins) {
            try {
                extensionPlugin.apply((ExtensionPoints)this.dataPrepperExtensionPoints);
            }
            catch (Exception e) {
                PluginError pluginError = PluginError.builder().componentType("extension").pluginName(this.extensionLoader.convertClassToName(extensionPlugin.getClass())).exception(e).build();
                this.pluginErrorCollector.collectPluginError(pluginError);
                LOG.error("Failed to apply extension plugin {}", extensionPlugin.getClass(), (Object)e);
            }
        }
        this.handlePluginErrors();
    }

    @PreDestroy
    public void shutdownExtensions() {
        this.loadedExtensionPlugins.forEach(ExtensionPlugin::shutdown);
    }

    private void handlePluginErrors() {
        List extensionPluginErrors = this.pluginErrorCollector.getPluginErrors().stream().filter(pluginError -> "extension".equals(pluginError.getComponentType())).collect(Collectors.toList());
        if (!extensionPluginErrors.isEmpty()) {
            this.pluginErrorsHandler.handleErrors(extensionPluginErrors);
            throw new RuntimeException("One or more extension plugins could not be applied correctly.");
        }
    }
}

