/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sqs.internal.batchmanager;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.sqs.batchmanager.BatchOverrideConfiguration;
import software.amazon.awssdk.services.sqs.model.MessageSystemAttributeName;

@SdkInternalApi
public final class ResponseBatchConfiguration {
    public static final Duration VISIBILITY_TIMEOUT_SECONDS_DEFAULT = null;
    public static final Duration MIN_RECEIVE_WAIT_TIME_MS_DEFAULT = Duration.ofMillis(50L);
    public static final List<String> RECEIVE_MESSAGE_ATTRIBUTE_NAMES_DEFAULT = Collections.emptyList();
    public static final List<MessageSystemAttributeName> MESSAGE_SYSTEM_ATTRIBUTE_NAMES_DEFAULT = Collections.emptyList();
    public static final int MAX_INFLIGHT_RECEIVE_BATCHES_DEFAULT = 10;
    public static final int MAX_DONE_RECEIVE_BATCHES_DEFAULT = 10;
    public static final int MAX_SUPPORTED_SQS_RECEIVE_MSG = 10;
    public static final int MAX_SEND_MESSAGE_PAYLOAD_SIZE_BYTES = 262144;
    public static final int ATTRIBUTE_MAPS_PAYLOAD_BYTES = 16384;
    private final Duration visibilityTimeout;
    private final Duration messageMinWaitDuration;
    private final List<MessageSystemAttributeName> messageSystemAttributeNames;
    private final List<String> receiveMessageAttributeNames;
    private final Integer maxBatchItems;
    private final Integer maxInflightReceiveBatches;
    private final Integer maxDoneReceiveBatches;

    private ResponseBatchConfiguration(Builder builder) {
        this.visibilityTimeout = builder.visibilityTimeout != null ? builder.visibilityTimeout : VISIBILITY_TIMEOUT_SECONDS_DEFAULT;
        this.messageMinWaitDuration = builder.messageMinWaitDuration != null ? builder.messageMinWaitDuration : MIN_RECEIVE_WAIT_TIME_MS_DEFAULT;
        this.messageSystemAttributeNames = builder.messageSystemAttributeNames != null ? builder.messageSystemAttributeNames : MESSAGE_SYSTEM_ATTRIBUTE_NAMES_DEFAULT;
        this.receiveMessageAttributeNames = builder.receiveMessageAttributeNames != null ? builder.receiveMessageAttributeNames : RECEIVE_MESSAGE_ATTRIBUTE_NAMES_DEFAULT;
        this.maxBatchItems = builder.maxBatchItems != null ? builder.maxBatchItems : 10;
        this.maxInflightReceiveBatches = builder.maxInflightReceiveBatches != null ? builder.maxInflightReceiveBatches : 10;
        this.maxDoneReceiveBatches = builder.maxDoneReceiveBatches != null ? builder.maxDoneReceiveBatches : 10;
    }

    public Duration visibilityTimeout() {
        return this.visibilityTimeout;
    }

    public Duration messageMinWaitDuration() {
        return this.messageMinWaitDuration;
    }

    public List<MessageSystemAttributeName> messageSystemAttributeNames() {
        return Collections.unmodifiableList(this.messageSystemAttributeNames);
    }

    public List<String> receiveMessageAttributeNames() {
        return Collections.unmodifiableList(this.receiveMessageAttributeNames);
    }

    public int maxBatchItems() {
        return this.maxBatchItems;
    }

    public int maxInflightReceiveBatches() {
        return this.maxInflightReceiveBatches;
    }

    public int maxDoneReceiveBatches() {
        return this.maxDoneReceiveBatches;
    }

    public static Builder builder(BatchOverrideConfiguration overrideConfiguration) {
        Builder builder = new Builder();
        if (overrideConfiguration != null) {
            builder.messageMinWaitDuration(overrideConfiguration.receiveMessageMinWaitDuration()).receiveMessageAttributeNames(overrideConfiguration.receiveMessageAttributeNames()).messageSystemAttributeNames(overrideConfiguration.receiveMessageSystemAttributeNames()).visibilityTimeout(overrideConfiguration.receiveMessageVisibilityTimeout());
        }
        return builder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration visibilityTimeout;
        private Duration messageMinWaitDuration;
        private List<MessageSystemAttributeName> messageSystemAttributeNames;
        private List<String> receiveMessageAttributeNames;
        private Integer maxBatchItems;
        private Integer maxInflightReceiveBatches;
        private Integer maxDoneReceiveBatches;

        public Builder visibilityTimeout(Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        public Builder messageMinWaitDuration(Duration messageMinWaitDuration) {
            this.messageMinWaitDuration = messageMinWaitDuration;
            return this;
        }

        public Builder messageSystemAttributeNames(List<MessageSystemAttributeName> messageSystemAttributeNames) {
            this.messageSystemAttributeNames = messageSystemAttributeNames;
            return this;
        }

        public Builder receiveMessageAttributeNames(List<String> receiveMessageAttributeNames) {
            this.receiveMessageAttributeNames = receiveMessageAttributeNames;
            return this;
        }

        public Builder maxBatchItems(Integer maxBatchItems) {
            this.maxBatchItems = maxBatchItems;
            return this;
        }

        public Builder maxInflightReceiveBatches(Integer maxInflightReceiveBatches) {
            this.maxInflightReceiveBatches = maxInflightReceiveBatches;
            return this;
        }

        public Builder maxDoneReceiveBatches(Integer maxDoneReceiveBatches) {
            this.maxDoneReceiveBatches = maxDoneReceiveBatches;
            return this;
        }

        public ResponseBatchConfiguration build() {
            return new ResponseBatchConfiguration(this);
        }
    }
}

