/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3.parser;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.opensearch.dataprepper.plugins.source.s3.S3EventNotification;
import org.opensearch.dataprepper.plugins.source.s3.parser.ParsedMessage;
import org.opensearch.dataprepper.plugins.source.s3.parser.S3NotificationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.model.Message;

public class S3EventNotificationParser
implements S3NotificationParser {
    private static final Logger LOG = LoggerFactory.getLogger(S3EventNotificationParser.class);
    private static final String SNS_MESSAGE_KEY = "Message";

    @Override
    public ParsedMessage parseMessage(Message message, ObjectMapper objectMapper) {
        try {
            JsonNode parsedNode = objectMapper.readTree(message.body());
            JsonNode eventNode = this.getS3EventNode(parsedNode, objectMapper);
            S3EventNotification s3EventNotification = (S3EventNotification)objectMapper.treeToValue((TreeNode)eventNode, S3EventNotification.class);
            if (s3EventNotification != null && s3EventNotification.getRecords() != null) {
                return new ParsedMessage(message, s3EventNotification.getRecords());
            }
            LOG.debug("SQS message with ID:{} does not have any S3 event notification records.", (Object)message.messageId());
            return new ParsedMessage(message, true);
        }
        catch (JsonProcessingException e) {
            if (message.body().contains("s3:TestEvent") && message.body().contains("Amazon S3")) {
                LOG.info("Received s3:TestEvent message. Deleting from SQS queue.");
                return new ParsedMessage(message, false);
            }
            LOG.error("SQS message with message ID:{} has invalid body which cannot be parsed into S3EventNotification. {}.", (Object)message.messageId(), (Object)e.getMessage());
            return new ParsedMessage(message, true);
        }
    }

    private JsonNode getS3EventNode(JsonNode parsedNode, ObjectMapper objectMapper) throws JsonProcessingException {
        if (this.isSnsWrappedMessage(parsedNode)) {
            String messageString = parsedNode.get(SNS_MESSAGE_KEY).asText();
            return (JsonNode)objectMapper.readValue(messageString, JsonNode.class);
        }
        return parsedNode;
    }

    private boolean isSnsWrappedMessage(JsonNode parsedNode) {
        return parsedNode.has(SNS_MESSAGE_KEY);
    }
}

