/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import org.joda.time.DateTime;
import org.opensearch.dataprepper.plugins.source.s3.DateTimeJsonSerializer;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class S3EventBridgeNotification {
    private final String version;
    private final String id;
    private final String detailType;
    private String source;
    private final String account;
    private DateTime time;
    private final String region;
    private final List<String> resources;
    private final Detail detail;

    @JsonCreator
    public S3EventBridgeNotification(@JsonProperty(value="version") String version, @JsonProperty(value="id") String id, @JsonProperty(value="detail-type") String detailType, @JsonProperty(value="source", required=true) String source, @JsonProperty(value="account", required=true) String account, @JsonProperty(value="time", required=true) String time, @JsonProperty(value="region", required=true) String region, @JsonProperty(value="resources", required=true) List<String> resources, @JsonProperty(value="detail", required=true) Detail detail) {
        this.version = version;
        this.id = id;
        this.detailType = detailType;
        this.source = source;
        this.account = account;
        if (time != null) {
            this.time = DateTime.parse((String)time);
        }
        this.region = region;
        this.resources = resources;
        this.detail = detail;
    }

    public String getVersion() {
        return this.version;
    }

    public String getId() {
        return this.id;
    }

    public String getDetailType() {
        return this.detailType;
    }

    public String getAccount() {
        return this.account;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @JsonSerialize(using=DateTimeJsonSerializer.class)
    public DateTime getTime() {
        return this.time;
    }

    public String getRegion() {
        return this.region;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public Detail getDetail() {
        return this.detail;
    }

    public static class Object {
        private final String key;
        private final long size;
        private final String etag;
        private final String versionId;
        private final String sequencer;

        public Object(@JsonProperty(value="key") String key, @JsonProperty(value="size") long size, @JsonProperty(value="etag") String etag, @JsonProperty(value="version-id") String versionId, @JsonProperty(value="sequencer") String sequencer) {
            this.key = key;
            this.size = size;
            this.etag = etag;
            this.versionId = versionId;
            this.sequencer = sequencer;
        }

        public long getSize() {
            return this.size;
        }

        public String getEtag() {
            return this.etag;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getSequencer() {
            return this.sequencer;
        }

        public String getUrlDecodedKey() {
            return SdkHttpUtils.urlDecode((String)this.key);
        }
    }

    public static class Bucket {
        private final String name;

        @JsonCreator
        public Bucket(@JsonProperty(value="name", required=true) String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Detail {
        private final String version;
        private final Bucket bucket;
        private final Object object;
        private final String requestId;
        private final String requester;
        private final String sourceIpAddress;
        private final String reason;

        @JsonCreator
        public Detail(@JsonProperty(value="version") String version, @JsonProperty(value="bucket", required=true) Bucket bucket, @JsonProperty(value="object", required=true) Object object, @JsonProperty(value="request-id") String requestId, @JsonProperty(value="requester") String requester, @JsonProperty(value="source-ip-address") String sourceIpAddress, @JsonProperty(value="reason") String reason) {
            this.version = version;
            this.bucket = bucket;
            this.object = object;
            this.requestId = requestId;
            this.requester = requester;
            this.sourceIpAddress = sourceIpAddress;
            this.reason = reason;
        }

        public String getVersion() {
            return this.version;
        }

        public Object getObject() {
            return this.object;
        }

        public Bucket getBucket() {
            return this.bucket;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public String getRequester() {
            return this.requester;
        }

        public String getSourceIpAddress() {
            return this.sourceIpAddress;
        }

        public String getReason() {
            return this.reason;
        }
    }
}

