/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.s3;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.plugins.s3.common.source.S3ObjectReference;

class EventMetadataModifier
implements BiConsumer<Event, S3ObjectReference> {
    private static final String BUCKET_FIELD_NAME = "bucket";
    private static final String KEY_FIELD_NAME = "key";
    private final String baseKey;
    private final boolean deleteS3MetadataInEvent;

    EventMetadataModifier(String metadataRootKey, boolean deleteS3MetadataInEvent) {
        this.baseKey = EventMetadataModifier.generateBaseKey(metadataRootKey);
        this.deleteS3MetadataInEvent = deleteS3MetadataInEvent;
    }

    @Override
    public void accept(Event event, S3ObjectReference s3ObjectReference) {
        if (!this.deleteS3MetadataInEvent) {
            event.put(this.baseKey + BUCKET_FIELD_NAME, (Object)s3ObjectReference.getBucketName());
            event.put(this.baseKey + KEY_FIELD_NAME, (Object)s3ObjectReference.getKey());
        }
    }

    private static String generateBaseKey(String metadataRootKey) {
        Objects.requireNonNull(metadataRootKey);
        if (metadataRootKey.startsWith("/")) {
            metadataRootKey = metadataRootKey.substring(1);
        }
        if (metadataRootKey.isEmpty() || metadataRootKey.endsWith("/")) {
            return metadataRootKey;
        }
        return metadataRootKey + "/";
    }
}

