/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline.server.config;

import com.sun.net.httpserver.Authenticator;
import java.util.Collections;
import org.opensearch.dataprepper.core.DataPrepper;
import org.opensearch.dataprepper.core.pipeline.PipelinesProvider;
import org.opensearch.dataprepper.core.pipeline.server.DataPrepperCoreAuthenticationProvider;
import org.opensearch.dataprepper.core.pipeline.server.GetPipelinesHandler;
import org.opensearch.dataprepper.core.pipeline.server.ListPipelinesHandler;
import org.opensearch.dataprepper.core.pipeline.server.ShutdownHandler;
import org.opensearch.dataprepper.model.configuration.PluginModel;
import org.opensearch.dataprepper.model.configuration.PluginSetting;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DataPrepperServerConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DataPrepperServerConfiguration.class);

    private void printInsecurePluginModelWarning() {
        LOG.warn("Creating data prepper server without authentication. This is not secure.");
        LOG.warn("In order to set up Http Basic authentication for the data prepper server, go here: https://github.com/opensearch-project/data-prepper/blob/main/docs/core_apis.md#authentication");
    }

    @Bean
    public PluginSetting pluginSetting(@Autowired(required=false) PluginModel authentication) {
        if (authentication != null) {
            String pluginName = authentication.getPluginName();
            if (pluginName.equals("unauthenticated")) {
                this.printInsecurePluginModelWarning();
            }
            return new PluginSetting(pluginName, authentication.getPluginSettings());
        }
        this.printInsecurePluginModelWarning();
        return new PluginSetting("unauthenticated", Collections.emptyMap());
    }

    @Bean
    public DataPrepperCoreAuthenticationProvider authenticationProvider(PluginFactory pluginFactory, PluginSetting pluginSetting) {
        return (DataPrepperCoreAuthenticationProvider)pluginFactory.loadPlugin(DataPrepperCoreAuthenticationProvider.class, pluginSetting, new Object[0]);
    }

    @Bean
    public Authenticator authenticator(DataPrepperCoreAuthenticationProvider authenticationProvider) {
        return authenticationProvider.getAuthenticator();
    }

    @Bean
    public ListPipelinesHandler listPipelinesHandler(PipelinesProvider pipelinesProvider) {
        return new ListPipelinesHandler(pipelinesProvider);
    }

    @Bean
    public ShutdownHandler shutdownHandler(DataPrepper dataPrepper) {
        return new ShutdownHandler(dataPrepper);
    }

    @Bean
    public GetPipelinesHandler GetPipelinesHandler(PipelinesProvider pipelinesProvider) {
        return new GetPipelinesHandler(pipelinesProvider);
    }
}

