/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.core.pipeline;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Counter;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.dataprepper.logging.DataPrepperMarkers;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.pipeline.HeadlessPipeline;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeadlessPipelineSource
implements Source<Record<Event>>,
HeadlessPipeline {
    private static final Logger LOG = LoggerFactory.getLogger(HeadlessPipelineSource.class);
    private static final String NUMBER_OF_SUCCESSFUL_EVENTS_COUNTER = "numberOfEventsSuccessful";
    private static final String NUMBER_OF_FAILED_EVENTS_COUNTER = "numberOfEventsFailed";
    public static final int DEFAULT_WRITE_TIMEOUT = Integer.MAX_VALUE;
    private Buffer buffer;
    private AtomicBoolean isStopRequested;
    private PluginMetrics pluginMetrics;
    private final Counter numberOfEventsSuccessful;
    private final Counter numberOfEventsFailed;
    private boolean acknowledgementsEnabled;

    public HeadlessPipelineSource(String componentName, String scope) {
        this.pluginMetrics = PluginMetrics.fromNames((String)componentName, (String)scope);
        this.isStopRequested = new AtomicBoolean(false);
        this.numberOfEventsSuccessful = this.pluginMetrics.counter(NUMBER_OF_SUCCESSFUL_EVENTS_COUNTER);
        this.numberOfEventsFailed = this.pluginMetrics.counter(NUMBER_OF_FAILED_EVENTS_COUNTER);
        this.acknowledgementsEnabled = false;
    }

    public void start(Buffer buffer) {
        this.buffer = buffer;
    }

    public void stop() {
        this.isStopRequested.set(true);
    }

    public void setAcknowledgementsEnabled(boolean acknowledgementsEnabled) {
        this.acknowledgementsEnabled = acknowledgementsEnabled;
    }

    @VisibleForTesting
    public boolean getAcknowledgementsEnabled() {
        return this.acknowledgementsEnabled;
    }

    @VisibleForTesting
    long getNumberOfSuccessfulEvents() {
        return (long)this.numberOfEventsSuccessful.count();
    }

    @VisibleForTesting
    long getNumberOfFailedEvents() {
        return (long)this.numberOfEventsFailed.count();
    }

    public void sendEvents(Collection<Record<Event>> records) {
        while (true) {
            try {
                this.buffer.writeAll(records, Integer.MAX_VALUE);
                this.numberOfEventsSuccessful.increment((double)records.size());
            }
            catch (Exception e) {
                LOG.error(DataPrepperMarkers.NOISY, "Failed to write to failure pipeline.", (Throwable)e);
                if (this.acknowledgementsEnabled) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                this.numberOfEventsFailed.increment((double)records.size());
                for (Record<Event> record : records) {
                    ((Event)record.getData()).getEventHandle().release(false);
                }
            }
            break;
        }
    }
}

