/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365.auth;

import java.time.Instant;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365SourceConfig;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.auth.Oauth2Config;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.auth.Office365AuthenticationInterface;
import org.opensearch.dataprepper.plugins.source.source_crawler.metrics.VendorAPIMetricsRecorder;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.DefaultRetryStrategy;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.DefaultStatusCodeHandler;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryHandler;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.RetryStrategy;
import org.opensearch.dataprepper.plugins.source.source_crawler.utils.retry.StatusCodeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Named
public class Office365AuthenticationProvider
implements Office365AuthenticationInterface {
    private static final Logger log = LoggerFactory.getLogger(Office365AuthenticationProvider.class);
    private static final String TOKEN_URL = "https://login.microsoftonline.com/%s/oauth2/v2.0/token";
    private static final String MANAGEMENT_API_SCOPE = "https://manage.office.com/.default";
    private static final String ACCESS_TOKEN_REQUEST_BODY = "grant_type=client_credentials&client_id=%s&client_secret=%s&scope=%s";
    private final RestTemplate restTemplate = new RestTemplate();
    private final RetryHandler retryHandler;
    private final String tenantId;
    private final Office365SourceConfig office365SourceConfig;
    private final VendorAPIMetricsRecorder metricsRecorder;
    private String accessToken;
    private final Object lock = new Object();
    private final Object accessTokenFetchLock = new Object();
    private final AtomicBoolean credentialsInitialized = new AtomicBoolean(false);
    private Instant expireTime = Instant.ofEpochMilli(0L);

    public Office365AuthenticationProvider(Office365SourceConfig config, VendorAPIMetricsRecorder metricsRecorder) {
        this.tenantId = config.getTenantId();
        this.office365SourceConfig = config;
        this.retryHandler = new RetryHandler((RetryStrategy)new DefaultRetryStrategy(), (StatusCodeHandler)new DefaultStatusCodeHandler());
        this.metricsRecorder = metricsRecorder;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renewCredentials() {
        Object object = this.lock;
        synchronized (object) {
            log.info("Getting new access token for Office 365 Management API");
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
            Oauth2Config oAuthConfig = this.office365SourceConfig.getAuthenticationConfiguration().getOauth2();
            oAuthConfig.getClientId().refresh();
            oAuthConfig.getClientSecret().refresh();
            String payload = String.format(ACCESS_TOKEN_REQUEST_BODY, (String)oAuthConfig.getClientId().getValue(), (String)oAuthConfig.getClientSecret().getValue(), MANAGEMENT_API_SCOPE);
            HttpEntity entity = new HttpEntity((Object)payload, (MultiValueMap)headers);
            String tokenEndpoint = String.format(TOKEN_URL, this.office365SourceConfig.getTenantId());
            try {
                ResponseEntity response = (ResponseEntity)this.metricsRecorder.recordAuthLatency(() -> (ResponseEntity)this.retryHandler.executeWithRetry(() -> this.restTemplate.postForEntity(tokenEndpoint, (Object)entity, Map.class, new Object[0]), () -> {}));
                Map tokenResponse = (Map)response.getBody();
                if (tokenResponse == null || tokenResponse.get("access_token") == null) {
                    throw new IllegalStateException("Invalid token response: missing access_token");
                }
                this.accessToken = (String)tokenResponse.get("access_token");
                int expiresIn = (Integer)tokenResponse.get("expires_in");
                this.expireTime = Instant.now().plusSeconds(expiresIn);
                this.metricsRecorder.recordAuthSuccess();
                log.info("Received new access token. Expires in {} seconds", (Object)expiresIn);
            }
            catch (Exception e) {
                this.metricsRecorder.recordAuthFailure();
                this.metricsRecorder.recordError(e);
                log.error("Failed to renew Office 365 credentials", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAccessToken() {
        if (!StringUtils.hasLength((String)this.accessToken)) {
            Object object = this.accessTokenFetchLock;
            synchronized (object) {
                if (!StringUtils.hasLength((String)this.accessToken)) {
                    this.initCredentials();
                }
            }
        }
        return this.accessToken;
    }

    public boolean isCredentialsInitialized() {
        return this.credentialsInitialized.get();
    }

    public void setCredentialsInitialized(boolean initialized) {
        this.credentialsInitialized.set(initialized);
    }

    public Instant getExpireTime() {
        return this.expireTime;
    }
}

