/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.dataprepper.plugins.source.microsoft_office365;

import java.time.Instant;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opensearch.dataprepper.metrics.PluginMetrics;
import org.opensearch.dataprepper.model.acknowledgements.AcknowledgementSetManager;
import org.opensearch.dataprepper.model.annotations.DataPrepperPlugin;
import org.opensearch.dataprepper.model.annotations.DataPrepperPluginConstructor;
import org.opensearch.dataprepper.model.buffer.Buffer;
import org.opensearch.dataprepper.model.event.Event;
import org.opensearch.dataprepper.model.plugin.PluginFactory;
import org.opensearch.dataprepper.model.record.Record;
import org.opensearch.dataprepper.model.source.Source;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.Office365SourceConfig;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.auth.Office365AuthenticationInterface;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.service.Office365Service;
import org.opensearch.dataprepper.plugins.source.microsoft_office365.utils.Constants;
import org.opensearch.dataprepper.plugins.source.source_crawler.CrawlerApplicationContextMarker;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.Crawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourceConfig;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.CrawlerSourcePlugin;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.DimensionalTimeSliceCrawler;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.LeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.base.PluginExecutorServiceProvider;
import org.opensearch.dataprepper.plugins.source.source_crawler.coordination.state.DimensionalTimeSliceLeaderProgressState;
import org.opensearch.dataprepper.plugins.source.source_crawler.metrics.VendorAPIMetricsRecorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DataPrepperPlugin(name="microsoft_office365", pluginType=Source.class, pluginConfigurationType=Office365SourceConfig.class, packagesToScan={CrawlerApplicationContextMarker.class, Office365Source.class})
public class Office365Source
extends CrawlerSourcePlugin {
    private static final Logger LOG = LoggerFactory.getLogger(Office365Source.class);
    private final Office365SourceConfig office365SourceConfig;
    private final Office365AuthenticationInterface office365AuthProvider;
    private final Office365Service office365Service;
    private final VendorAPIMetricsRecorder vendorAPIMetricsRecorder;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);

    @DataPrepperPluginConstructor
    public Office365Source(PluginMetrics pluginMetrics, Office365SourceConfig office365SourceConfig, Office365AuthenticationInterface office365AuthProvider, PluginFactory pluginFactory, AcknowledgementSetManager acknowledgementSetManager, DimensionalTimeSliceCrawler crawler, PluginExecutorServiceProvider executorServiceProvider, Office365Service office365Service, VendorAPIMetricsRecorder vendorAPIMetricsRecorder) {
        super("microsoft_office365", pluginMetrics, (CrawlerSourceConfig)office365SourceConfig, pluginFactory, acknowledgementSetManager, (Crawler)crawler, executorServiceProvider);
        crawler.initialize(Arrays.asList(Constants.CONTENT_TYPES));
        LOG.info("Creating Office365 Source Plugin");
        this.office365SourceConfig = office365SourceConfig;
        this.office365AuthProvider = office365AuthProvider;
        this.office365Service = office365Service;
        this.vendorAPIMetricsRecorder = vendorAPIMetricsRecorder;
        this.vendorAPIMetricsRecorder.enableSubscriptionMetrics();
    }

    public void start(Buffer<Record<Event>> buffer) {
        LOG.info("Starting Office365 Source Plugin...");
        try {
            this.office365AuthProvider.initCredentials();
            this.office365Service.initializeSubscriptions();
            super.start(buffer);
        }
        catch (Exception e) {
            LOG.error("Error starting Office365 Source Plugin", (Throwable)e);
            this.isRunning.set(false);
            throw new RuntimeException("Failed to start Office365 Source Plugin", e);
        }
    }

    protected LeaderProgressState createLeaderProgressState() {
        return new DimensionalTimeSliceLeaderProgressState(Instant.now(), this.office365SourceConfig.getLookBackHours());
    }

    public void stop() {
        LOG.info("Stopping Office365 Source Plugin");
        super.stop();
    }
}

