/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.ChangePasswordResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ChangePasswordRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String password;
    @Nullable
    private final String passwordHash;
    @Nullable
    private final Refresh refresh;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<ChangePasswordRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ChangePasswordRequest::setupChangePasswordRequestDeserializer);
    public static final Endpoint<ChangePasswordRequest, ChangePasswordResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<ChangePasswordRequest, ChangePasswordResponse>("es/security.change_password", request -> "PUT", request -> {
        boolean _username = true;
        boolean propsSet = false;
        if (request.username() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.username, buf);
            buf.append("/_password");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_security");
            buf.append("/user");
            buf.append("/_password");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.refresh != null) {
            params.put("refresh", request.refresh.jsonValue());
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, ChangePasswordResponse._DESERIALIZER);

    private ChangePasswordRequest(Builder builder) {
        this.password = builder.password;
        this.passwordHash = builder.passwordHash;
        this.refresh = builder.refresh;
        this.username = builder.username;
    }

    public static ChangePasswordRequest of(Function<Builder, ObjectBuilder<ChangePasswordRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String password() {
        return this.password;
    }

    @Nullable
    public final String passwordHash() {
        return this.passwordHash;
    }

    @Nullable
    public final Refresh refresh() {
        return this.refresh;
    }

    @Nullable
    public final String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.password != null) {
            generator.writeKey("password");
            generator.write(this.password);
        }
        if (this.passwordHash != null) {
            generator.writeKey("password_hash");
            generator.write(this.passwordHash);
        }
    }

    protected static void setupChangePasswordRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::password, JsonpDeserializer.stringDeserializer(), "password");
        op.add(Builder::passwordHash, JsonpDeserializer.stringDeserializer(), "password_hash");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ChangePasswordRequest> {
        @Nullable
        private String password;
        @Nullable
        private String passwordHash;
        @Nullable
        private Refresh refresh;
        @Nullable
        private String username;

        public final Builder password(@Nullable String value) {
            this.password = value;
            return this;
        }

        public final Builder passwordHash(@Nullable String value) {
            this.passwordHash = value;
            return this;
        }

        public final Builder refresh(@Nullable Refresh value) {
            this.refresh = value;
            return this;
        }

        public final Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        public ChangePasswordRequest build() {
            this._checkSingleUse();
            return new ChangePasswordRequest(this);
        }
    }
}

